/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.inject.ServerInjectableProviderContext;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.app.WebEngineModuleFactory;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationFactory;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestContext;
import org.nuxeo.ecm.webengine.jaxrs.scan.Scanner;
import org.nuxeo.ecm.webengine.loader.WebLoader;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.model.impl.ModuleManager;
import org.osgi.framework.Bundle;

public class WebEngineModule
extends Application
implements ApplicationFactory {
    private static final Log log = LogFactory.getLog(WebEngineModule.class);
    public static final String WEBOBJECT_ANNO = "Lorg/nuxeo/ecm/webengine/model/WebObject;";
    public static final String WEBADAPTER_ANNO = "Lorg/nuxeo/ecm/webengine/model/WebAdapter;";
    protected ServerInjectableProviderContext context;
    protected Bundle bundle;
    protected ModuleConfiguration cfg;

    void init(WebEngine engine, Bundle bundle, File configuration, Map<String, String> attrs) throws ReflectiveOperationException, IOException {
        this.bundle = bundle;
        this.loadModuleConfigurationFile(engine, configuration);
        if (attrs != null) {
            String v = attrs.get("name");
            if (v != null) {
                this.cfg.name = v;
            }
            if ((v = attrs.get("extends")) != null) {
                this.cfg.base = v;
            }
            if ((v = attrs.get("headless")) != null) {
                this.cfg.isHeadless = Boolean.parseBoolean(v);
            }
        }
        if (this.cfg.name == null) {
            throw new IllegalStateException("No name given for web module in bundle " + bundle.getSymbolicName());
        }
        this.initTypes(bundle, attrs.get("package"), engine);
    }

    private void initTypes(Bundle bundle, String packageBase, WebEngine engine) throws ReflectiveOperationException, IOException {
        this.cfg.types = this.getWebTypes();
        if (this.cfg.types == null) {
            this.loadMetaTypeFile(engine);
            if (this.cfg.types == null) {
                this.scan(bundle, packageBase);
                if (this.cfg.types == null) {
                    throw new IllegalStateException("No web types defined in web module " + this.cfg.name + " from bundle " + bundle.getSymbolicName());
                }
            } else {
                this.initRoots(engine);
            }
        } else {
            this.initRoots(engine);
        }
    }

    private void scan(Bundle bundle, String packageBase) throws ReflectiveOperationException, IOException {
        if (packageBase == null) {
            packageBase = "/";
        }
        Scanner scanner = new Scanner(bundle, packageBase, new String[]{"Ljavax/ws/rs/Path;", "Ljavax/ws/rs/ext/Provider;", WEBOBJECT_ANNO, WEBADAPTER_ANNO});
        scanner.scan();
        Collection paths = scanner.getCollector("Ljavax/ws/rs/Path;");
        Collection providers = scanner.getCollector("Ljavax/ws/rs/ext/Provider;");
        this.cfg.roots = new Class[paths.size() + providers.size()];
        int i = 0;
        for (Class cl : paths) {
            this.cfg.roots[i++] = cl;
        }
        for (Class cl : providers) {
            this.cfg.roots[i++] = cl;
        }
        Collection objs = scanner.getCollector(WEBOBJECT_ANNO);
        Collection adapters = scanner.getCollector(WEBADAPTER_ANNO);
        this.cfg.types = new Class[objs.size() + adapters.size()];
        i = 0;
        for (Class cl : objs) {
            this.cfg.types[i++] = cl;
        }
        for (Class cl : adapters) {
            this.cfg.types[i++] = cl;
        }
    }

    private void loadMetaTypeFile(WebEngine engine) throws ReflectiveOperationException, IOException {
        URL url = this.bundle.getEntry("META-INF/web-types");
        if (url != null) {
            try (InputStream in = url.openStream();){
                this.cfg.types = WebEngineModule.readWebTypes(engine.getWebLoader(), in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?>[] readWebTypes(WebLoader loader, InputStream in) throws ReflectiveOperationException, IOException {
        HashSet types = new HashSet();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                int p = line.indexOf(124);
                if (p > -1) {
                    line = line.substring(0, p);
                }
                Class<?> cl = loader.loadClass(line);
                types.add(cl);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return types.toArray(new Class[types.size()]);
    }

    private void initRoots(WebEngine engine) {
        ArrayList roots = new ArrayList();
        for (Class<?> cl : this.cfg.types) {
            WebObject wo;
            if (cl.isAnnotationPresent(Path.class)) {
                roots.add(cl);
                continue;
            }
            if (this.cfg.rootType == null || (wo = cl.getAnnotation(WebObject.class)) == null || !wo.type().equals(this.cfg.rootType)) continue;
            log.warn((Object)("Invalid web module " + this.cfg.name + " from bundle " + this.bundle.getSymbolicName() + ". The root-type " + cl + " in module.xml is deprecated. Consider using @Path annotation on you root web objects."));
        }
        if (roots.isEmpty()) {
            log.error((Object)("No root web objects found in web module " + this.cfg.name + " from bundle " + this.bundle.getSymbolicName()));
        }
        this.cfg.roots = roots.toArray(new Class[roots.size()]);
    }

    private ModuleConfiguration loadModuleConfigurationFile(WebEngine engine, File file) throws IOException {
        this.cfg = file != null && file.isFile() ? ModuleManager.readConfiguration(engine, file) : new ModuleConfiguration();
        this.cfg.engine = engine;
        this.cfg.file = file;
        return this.cfg;
    }

    public ModuleConfiguration getConfiguration() {
        return this.cfg;
    }

    public Module getModule(WebContext context) {
        return this.cfg.get(context);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Set<Class<?>> getClasses() {
        if (this.cfg.roots == null) {
            return new HashSet();
        }
        HashSet set = new HashSet();
        Collections.addAll(set, this.cfg.roots);
        return set;
    }

    public Set<Object> getSingletons() {
        HashSet<Object> set = new HashSet<Object>();
        set.add(new HttpServletRequestProvider());
        set.add(new HttpServletResponseProvider());
        return set;
    }

    public String getId() {
        return this.bundle.getSymbolicName();
    }

    public Class<?>[] getWebTypes() {
        return null;
    }

    public Application getApplication(Bundle bundle, Map<String, String> args) throws ReflectiveOperationException, IOException {
        return WebEngineModuleFactory.getApplication(this, bundle, args);
    }

    public static class HttpServletResponseProvider
    implements InjectableProvider<Context, Type>,
    Injectable<HttpServletResponse> {
        public HttpServletResponse getValue() {
            RequestContext ctx = RequestContext.getActiveContext();
            return ctx != null ? ctx.getResponse() : null;
        }

        public ComponentScope getScope() {
            return ComponentScope.PerRequest;
        }

        public Injectable<HttpServletResponse> getInjectable(ComponentContext ic, Context a, Type c) {
            if (!c.equals(HttpServletResponse.class)) {
                return null;
            }
            return this;
        }
    }

    public static class HttpServletRequestProvider
    implements InjectableProvider<Context, Type>,
    Injectable<HttpServletRequest> {
        public HttpServletRequest getValue() {
            RequestContext ctx = RequestContext.getActiveContext();
            return ctx != null ? ctx.getRequest() : null;
        }

        public ComponentScope getScope() {
            return ComponentScope.PerRequest;
        }

        public Injectable<HttpServletRequest> getInjectable(ComponentContext ic, Context a, Type c) {
            if (!c.equals(HttpServletRequest.class)) {
                return null;
            }
            return this;
        }
    }
}

