/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.runtime.api.Framework;

public abstract class UnrestrictedSessionRunner {
    private static final Log log = LogFactory.getLog(UnrestrictedSessionRunner.class);
    protected String originatingUsername;
    protected CoreSession session;
    protected final boolean sessionIsAlreadyUnrestricted;
    protected final String repositoryName;
    protected boolean isUnrestricted;

    protected UnrestrictedSessionRunner(CoreSession session) {
        this.session = session;
        this.sessionIsAlreadyUnrestricted = this.checkUnrestricted(session);
        this.repositoryName = this.sessionIsAlreadyUnrestricted ? null : session.getRepositoryName();
        NuxeoPrincipal pal = session.getPrincipal();
        if (pal != null) {
            this.originatingUsername = pal.getName();
        }
    }

    protected UnrestrictedSessionRunner(String repositoryName) {
        this.session = null;
        this.sessionIsAlreadyUnrestricted = false;
        this.repositoryName = repositoryName;
    }

    protected UnrestrictedSessionRunner(String repositoryName, String originatingUser) {
        this.session = null;
        this.sessionIsAlreadyUnrestricted = false;
        this.repositoryName = repositoryName;
        this.originatingUsername = originatingUser;
    }

    public String getOriginatingUsername() {
        return this.originatingUsername;
    }

    public void setOriginatingUsername(String originatingUsername) {
        this.originatingUsername = originatingUsername;
    }

    protected boolean checkUnrestricted(CoreSession session) {
        return session.getPrincipal().isAdministrator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUnrestricted() {
        this.isUnrestricted = true;
        try {
            LoginContext loginContext;
            if (this.sessionIsAlreadyUnrestricted) {
                if (ClientLoginModule.isCurrentAdministrator()) {
                    this.run();
                } else {
                    Framework.doPrivileged(this::run);
                }
                return;
            }
            try {
                loginContext = Framework.loginAs((String)this.originatingUsername);
            }
            catch (LoginException e) {
                throw new NuxeoException(e);
            }
            try {
                CoreSession baseSession = this.session;
                try (CloseableCoreSession closeableCoreSession = CoreInstance.openCoreSession(this.repositoryName);){
                    this.session = closeableCoreSession;
                    this.run();
                }
                finally {
                    this.session = baseSession;
                }
            }
            finally {
                try {
                    if (loginContext != null) {
                        loginContext.logout();
                    }
                }
                catch (LoginException e) {
                    log.error((Object)e);
                }
            }
        }
        finally {
            this.isUnrestricted = false;
        }
    }

    public abstract void run();
}

