/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.LocalBinaryManager;

public class DefaultBinaryManager
extends LocalBinaryManager {
    @Override
    public Binary getBinary(Blob blob) throws IOException {
        if (!(blob instanceof FileBlob) || !((FileBlob)blob).isTemporary()) {
            return super.getBinary(blob);
        }
        String digest = this.storeAndDigest((FileBlob)blob);
        File file = this.getFileForDigest(digest, false);
        return new Binary(file, digest, this.blobProviderId);
    }

    protected String storeAndDigest(FileBlob blob) throws IOException {
        File digestFile;
        String digest;
        if (StringUtils.isEmpty((CharSequence)blob.getDigest())) {
            try (InputStream in = blob.getStream();){
                digest = this.storeAndDigest(in, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            }
        } else {
            digest = blob.getDigest();
        }
        if ((digestFile = this.getFileForDigest(digest, true)).exists()) {
            digestFile.setLastModified(blob.getFile().lastModified());
        } else {
            blob.moveTo(digestFile);
        }
        return digest;
    }
}

