/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.ScrollResult;

public class ScrollResultImpl<T>
implements ScrollResult<T> {
    protected static final ScrollResult<?> EMPTY_RESULT = new ScrollResultImpl("empty", Collections.emptyList());
    protected final String scrollId;
    protected final List<T> results;

    public static <O> ScrollResult<O> emptyResult() {
        return EMPTY_RESULT;
    }

    public ScrollResultImpl(String scrollId, List<T> results) {
        this.scrollId = scrollId;
        this.results = Collections.unmodifiableList(results);
    }

    @Override
    public String getScrollId() {
        return this.scrollId;
    }

    @Override
    public boolean hasResults() {
        return this.results != null && !this.results.isEmpty();
    }

    @Override
    public List<T> getResults() {
        return this.results;
    }
}

