/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.security.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.AdministratorGroupsProvider;
import org.nuxeo.runtime.api.Framework;

public class ACLImpl
extends ArrayList<ACE>
implements ACL {
    private static final long serialVersionUID = 5332101749929771434L;
    private static final Log log = LogFactory.getLog(ACLImpl.class);
    private final String name;
    private final boolean isReadOnly;

    public ACLImpl(String name, boolean isReadOnly) {
        if (name == null) {
            log.debug((Object)"ACL name is null");
            if (log.isTraceEnabled()) {
                log.trace((Object)"ACL name is null", (Throwable)new NuxeoException("trace"));
            }
            name = "local";
        }
        this.name = name;
        this.isReadOnly = isReadOnly;
    }

    public ACLImpl() {
        this("local", false);
    }

    public ACLImpl(String name) {
        this(name, false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ACE[] getACEs() {
        return this.toArray(new ACE[this.size()]);
    }

    @Override
    public void setACEs(ACE[] aces) {
        this.clear();
        this.addAll(Arrays.asList(aces));
        this.warnForDuplicateACEs(aces);
    }

    private void warnForDuplicateACEs(ACE[] aces) {
        if (!log.isWarnEnabled() || "inherited".equals(this.name)) {
            return;
        }
        HashSet<ACE> aceSet = new HashSet<ACE>(aces.length);
        for (ACE ace : aces) {
            if (aceSet.add(ace)) continue;
            Throwable throwable = null;
            if (log.isTraceEnabled()) {
                throwable = new Throwable();
            }
            log.warn((Object)("Setting an ACL with at least one duplicate entry: " + ace + ", ACL entries: " + Arrays.toString(aces)), throwable);
            break;
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public boolean blockInheritance(String username) {
        boolean aclChanged = false;
        ArrayList aces = Lists.newArrayList((Object[])this.getACEs());
        if (!aces.contains(ACE.BLOCK)) {
            aces.add(ACE.builder(username, "Everything").creator(username).build());
            aces.addAll(this.getAdminEverythingACES());
            aces.add(ACE.BLOCK);
            aclChanged = true;
            this.setACEs(aces.toArray(new ACE[aces.size()]));
        }
        return aclChanged;
    }

    @Override
    public boolean unblockInheritance() {
        boolean aclChanged = false;
        ArrayList aces = Lists.newArrayList((Object[])this.getACEs());
        if (aces.contains(ACE.BLOCK)) {
            aces.remove(ACE.BLOCK);
            aclChanged = true;
            this.setACEs(aces.toArray(new ACE[aces.size()]));
        }
        return aclChanged;
    }

    @Override
    public boolean add(ACE ace) {
        boolean aclChanged = false;
        ArrayList aces = Lists.newArrayList((Object[])this.getACEs());
        if (!aces.contains(ace)) {
            int pos = aces.indexOf(ACE.BLOCK);
            if (pos >= 0) {
                aces.add(pos, ace);
            } else {
                aces.add(ace);
            }
            aclChanged = true;
            this.setACEs(aces.toArray(new ACE[aces.size()]));
        }
        return aclChanged;
    }

    protected List<ACE> getAdminEverythingACES() {
        ArrayList<ACE> aces = new ArrayList<ACE>();
        AdministratorGroupsProvider provider = (AdministratorGroupsProvider)Framework.getService(AdministratorGroupsProvider.class);
        List<String> administratorsGroups = provider.getAdministratorsGroups();
        for (String adminGroup : administratorsGroups) {
            aces.add(new ACE(adminGroup, "Everything", true));
        }
        return aces;
    }

    @Override
    public boolean replace(ACE oldACE, ACE newACE) {
        boolean aclChanged = false;
        int index = this.indexOf(oldACE);
        if (index != -1) {
            this.remove(oldACE);
            this.add(index, newACE);
            aclChanged = true;
        }
        return aclChanged;
    }

    @Override
    public boolean removeByUsername(String username) {
        boolean aclChanged = false;
        ArrayList aces = Lists.newArrayList((Object[])this.getACEs());
        Iterator it = aces.iterator();
        while (it.hasNext()) {
            ACE ace = (ACE)it.next();
            if (!ace.getUsername().equals(username)) continue;
            it.remove();
            aclChanged = true;
        }
        this.setACEs(aces.toArray(new ACE[aces.size()]));
        return aclChanged;
    }

    @Override
    public void replacePermission(String oldPerm, String newPerm) {
        ListIterator<ACE> it = this.listIterator();
        while (it.hasNext()) {
            ACE ace = (ACE)it.next();
            if (!ace.getPermission().equals(oldPerm)) continue;
            ace = ACE.builder(ace).permission(newPerm).build();
            it.set(ace);
        }
    }

    @Override
    public Object clone() {
        ACLImpl copy = new ACLImpl(this.name, this.isReadOnly);
        ACE[] aces = new ACE[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            aces[i] = (ACE)((ACE)this.get(i)).clone();
        }
        copy.setACEs(aces);
        return copy;
    }
}

