/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.validation;

import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.validation.ConstraintViolation;
import org.nuxeo.ecm.core.api.validation.DocumentValidationReport;

public class DocumentValidationException
extends NuxeoException {
    protected static final String MESSAGE_SINGLE = "Constraint violation thrown on property %s: '%s'";
    protected static final String MESSAGE = "%s constraint violation(s) thrown. First one is thrown on property %s: '%s', call " + DocumentValidationException.class.getSimpleName() + ".getViolations() to get the others";
    private static final long serialVersionUID = 1L;
    private DocumentValidationReport report;

    public DocumentValidationException(DocumentValidationReport report) {
        this.report = report;
    }

    public DocumentValidationReport getReport() {
        return this.report;
    }

    @Override
    public String getMessage() {
        if (this.report.hasError()) {
            int num = this.report.numberOfErrors();
            ConstraintViolation violation = this.report.asList().get(0);
            String xpath = violation.getPathAsString();
            String violationMessage = violation.getMessage(null);
            if (num > 1) {
                return String.format(MESSAGE, this.report.numberOfErrors(), xpath, violationMessage);
            }
            return String.format(MESSAGE_SINGLE, xpath, violationMessage);
        }
        return super.getMessage();
    }
}

