/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.validation.ConstraintViolation;
import org.nuxeo.ecm.core.api.validation.DocumentValidationDescriptor;
import org.nuxeo.ecm.core.api.validation.DocumentValidationReport;
import org.nuxeo.ecm.core.api.validation.DocumentValidationService;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;
import org.nuxeo.ecm.core.schema.types.constraints.NotNullConstraint;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocumentValidationServiceImpl
extends DefaultComponent
implements DocumentValidationService {
    private SchemaManager schemaManager;
    private Map<String, Boolean> validationActivations = new HashMap<String, Boolean>();

    protected SchemaManager getSchemaManager() {
        if (this.schemaManager == null) {
            this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        }
        return this.schemaManager;
    }

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("activations")) {
            DocumentValidationDescriptor dvd = (DocumentValidationDescriptor)contribution;
            this.validationActivations.put(dvd.getContext(), dvd.isActivated());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("activations")) {
            DocumentValidationDescriptor dvd = (DocumentValidationDescriptor)contribution;
            this.validationActivations.remove(dvd.getContext());
        }
    }

    @Override
    public boolean isActivated(String context, Map<String, Serializable> contextMap) {
        Boolean activated;
        DocumentValidationService.Forcing flag;
        if (contextMap != null && (flag = (DocumentValidationService.Forcing)((Object)contextMap.get("DocumentValidationService.Forcing"))) != null) {
            switch (flag) {
                case TURN_ON: {
                    return true;
                }
                case TURN_OFF: {
                    return false;
                }
            }
        }
        if ((activated = this.validationActivations.get(context)) == null) {
            return false;
        }
        return activated;
    }

    @Override
    public DocumentValidationReport validate(DocumentModel document) {
        return this.validate(document, false);
    }

    @Override
    public DocumentValidationReport validate(DocumentModel document, boolean dirtyOnly) {
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        DocumentType docType = document.getDocumentType();
        if (dirtyOnly) {
            for (DataModel dataModel : document.getDataModels().values()) {
                Schema schemaDef = this.getSchemaManager().getSchema(dataModel.getSchema());
                for (String fieldName : dataModel.getDirtyFields()) {
                    Field field = schemaDef.getField(fieldName);
                    Property property = document.getProperty(field.getName().getPrefixedName());
                    List<ConstraintViolation.PathNode> path = Collections.singletonList(new ConstraintViolation.PathNode(property.getField()));
                    violations.addAll(this.validateAnyTypeProperty(property.getSchema(), path, property, true, true));
                }
            }
        } else {
            for (Schema schema : docType.getSchemas()) {
                for (Field field : schema.getFields()) {
                    Property property = document.getProperty(field.getName().getPrefixedName());
                    List<ConstraintViolation.PathNode> path = Collections.singletonList(new ConstraintViolation.PathNode(property.getField()));
                    violations.addAll(this.validateAnyTypeProperty(property.getSchema(), path, property, false, true));
                }
            }
        }
        return new DocumentValidationReport(violations);
    }

    @Override
    public DocumentValidationReport validate(Field field, Object value) {
        return this.validate(field, value, true);
    }

    @Override
    public DocumentValidationReport validate(Field field, Object value, boolean validateSubProperties) {
        Schema schema = field.getDeclaringType().getSchema();
        return new DocumentValidationReport(this.validate(schema, field, value, validateSubProperties));
    }

    @Override
    public DocumentValidationReport validate(Property property) {
        return this.validate(property, true);
    }

    @Override
    public DocumentValidationReport validate(Property property, boolean validateSubProperties) {
        ArrayList<ConstraintViolation.PathNode> path = new ArrayList<ConstraintViolation.PathNode>();
        for (Property inspect = property; inspect != null && !(inspect instanceof DocumentPart); inspect = inspect.getParent()) {
            path.add(0, new ConstraintViolation.PathNode(inspect.getField()));
        }
        return new DocumentValidationReport(this.validateAnyTypeProperty(property.getSchema(), path, property, false, validateSubProperties));
    }

    @Override
    public DocumentValidationReport validate(String xpath, Object value) {
        return this.validate(xpath, value, true);
    }

    @Override
    public DocumentValidationReport validate(String xpath, Object value, boolean validateSubProperties) throws IllegalArgumentException {
        SchemaManager tm = (SchemaManager)Framework.getService(SchemaManager.class);
        String[] splittedXpath = xpath.split("/");
        ArrayList<ConstraintViolation.PathNode> path = new ArrayList<ConstraintViolation.PathNode>();
        Field field = null;
        StringBuilder fieldXpath = new StringBuilder(xpath.length());
        for (String xpathToken : splittedXpath) {
            if (field != null && field.getType().isListType()) {
                Field itemField = ((ListType)field.getType()).getField();
                if (xpathToken.matches("\\d+")) {
                    fieldXpath.append('/').append(xpathToken);
                    field = itemField;
                    int index = Integer.parseInt(xpathToken);
                    path.add(new ConstraintViolation.PathNode(field, index));
                    continue;
                }
                if (xpathToken.equals(itemField.getName().getLocalName())) {
                    field = itemField;
                    path.add(new ConstraintViolation.PathNode(field));
                    continue;
                }
                fieldXpath.append('/').append(xpathToken);
                field = itemField;
                path.add(new ConstraintViolation.PathNode(field));
                field = tm.getField(fieldXpath.toString());
                if (field == null) {
                    throw new IllegalArgumentException("Invalid xpath " + fieldXpath);
                }
                path.add(new ConstraintViolation.PathNode(field));
                continue;
            }
            if (fieldXpath.length() != 0) {
                fieldXpath.append('/');
            }
            fieldXpath.append(xpathToken);
            field = tm.getField(fieldXpath.toString());
            if (field == null) {
                throw new IllegalArgumentException("Invalid xpath " + fieldXpath);
            }
            path.add(new ConstraintViolation.PathNode(field));
        }
        Schema schema = field.getDeclaringType().getSchema();
        return new DocumentValidationReport(this.validateAnyTypeField(schema, path, field, value, validateSubProperties));
    }

    protected List<ConstraintViolation> validate(Schema schema, Field field, Object value, boolean validateSubProperties) {
        List<ConstraintViolation.PathNode> path = Collections.singletonList(new ConstraintViolation.PathNode(field));
        return this.validateAnyTypeField(schema, path, field, value, validateSubProperties);
    }

    private List<ConstraintViolation> validateAnyTypeField(Schema schema, List<ConstraintViolation.PathNode> path, Field field, Object value, boolean validateSubProperties) {
        if (field.getType().isSimpleType()) {
            return this.validateSimpleTypeField(schema, path, field, value);
        }
        if (field.getType().isComplexType()) {
            List<ConstraintViolation> subs;
            ArrayList<ConstraintViolation> res = new ArrayList<ConstraintViolation>();
            if (!field.isNillable() && (value == null || value instanceof Map && ((Map)value).isEmpty())) {
                this.addNotNullViolation(res, schema, path);
            }
            if (validateSubProperties && (subs = this.validateComplexTypeField(schema, path, field, value)) != null) {
                res.addAll(subs);
            }
            return res;
        }
        if (field.getType().isListType() && validateSubProperties) {
            return this.validateListTypeField(schema, path, field, value);
        }
        return Collections.emptyList();
    }

    private List<ConstraintViolation> validateSimpleTypeField(Schema schema, List<ConstraintViolation.PathNode> path, Field field, Object value) {
        Type type = field.getType();
        assert (type.isSimpleType() || type.isListType());
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        Set constraints = type.isListType() ? ((ListType)type).getFieldType().getConstraints() : field.getConstraints();
        for (Constraint constraint : constraints) {
            if (constraint.validate(value)) continue;
            ConstraintViolation violation = new ConstraintViolation(schema, path, constraint, value);
            violations.add(violation);
        }
        return violations;
    }

    private List<ConstraintViolation> validateComplexTypeField(Schema schema, List<ConstraintViolation.PathNode> path, Field field, Object value) {
        assert (field.getType().isComplexType());
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        ComplexType complexType = (ComplexType)field.getType();
        if (!(value instanceof Map)) {
            return violations;
        }
        Map map = (Map)value;
        for (Field child : complexType.getFields()) {
            Object item = map.get(child.getName().getLocalName());
            ArrayList<ConstraintViolation.PathNode> subPath = new ArrayList<ConstraintViolation.PathNode>(path);
            subPath.add(new ConstraintViolation.PathNode(child));
            violations.addAll(this.validateAnyTypeField(schema, subPath, child, item, true));
        }
        return violations;
    }

    private List<ConstraintViolation> validateListTypeField(Schema schema, List<ConstraintViolation.PathNode> path, Field field, Object value) {
        assert (field.getType().isListType());
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        List<Object> castedValue = null;
        if (!field.isNillable() && value == null) {
            this.addNotNullViolation(violations, schema, path);
        }
        if (value instanceof List) {
            castedValue = (List<Object>)value;
        } else if (value instanceof Object[]) {
            castedValue = Arrays.asList((Object[])value);
        }
        if (castedValue != null) {
            if (!field.isNillable() && castedValue.isEmpty()) {
                this.addNotNullViolation(violations, schema, path);
            }
            ListType listType = (ListType)field.getType();
            Field listField = listType.getField();
            int index = 0;
            for (Object e : castedValue) {
                ArrayList<ConstraintViolation.PathNode> subPath = new ArrayList<ConstraintViolation.PathNode>(path);
                subPath.add(new ConstraintViolation.PathNode(listField, index));
                violations.addAll(this.validateAnyTypeField(schema, subPath, listField, e, true));
                ++index;
            }
            return violations;
        }
        return violations;
    }

    private List<ConstraintViolation> validateAnyTypeProperty(Schema schema, List<ConstraintViolation.PathNode> path, Property prop, boolean dirtyOnly, boolean validateSubProperties) {
        Field field = prop.getField();
        if (!dirtyOnly || prop.isDirty()) {
            if (field.getType().isSimpleType()) {
                return this.validateSimpleTypeProperty(schema, path, prop, dirtyOnly);
            }
            if (field.getType().isComplexType()) {
                if (validateSubProperties) {
                    return this.validateComplexTypeProperty(schema, path, prop, dirtyOnly);
                }
            } else if (field.getType().isListType() && validateSubProperties) {
                return this.validateListTypeProperty(schema, path, prop, dirtyOnly);
            }
        }
        return Collections.emptyList();
    }

    private List<ConstraintViolation> validateSimpleTypeProperty(Schema schema, List<ConstraintViolation.PathNode> path, Property prop, boolean dirtyOnly) {
        Field field = prop.getField();
        assert (field.getType().isSimpleType() || prop.isScalar());
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        Serializable value = prop.getValue();
        Object defaultValue = field.getDefaultValue();
        if (prop.isPhantom() && defaultValue == null || value == null) {
            if (!field.isNillable()) {
                this.addNotNullViolation(violations, schema, path);
            }
        } else {
            violations.addAll(this.validateSimpleTypeField(schema, path, field, value));
        }
        return violations;
    }

    private List<ConstraintViolation> validateComplexTypeProperty(Schema schema, List<ConstraintViolation.PathNode> path, Property prop, boolean dirtyOnly) {
        Field field = prop.getField();
        assert (field.getType().isComplexType());
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        boolean allChildrenPhantom = true;
        for (Property child : prop.getChildren()) {
            if (child.isPhantom()) continue;
            allChildrenPhantom = false;
            break;
        }
        Serializable value = prop.getValue();
        if (prop.isPhantom() || value == null || allChildrenPhantom) {
            if (!field.isNillable()) {
                this.addNotNullViolation(violations, schema, path);
            }
        } else if (value instanceof Map) {
            Map castedValue = (Map)((Object)value);
            if (castedValue.isEmpty() || castedValue.values().stream().allMatch(Objects::isNull)) {
                if (!field.isNillable()) {
                    this.addNotNullViolation(violations, schema, path);
                }
            } else {
                for (Property child : prop.getChildren()) {
                    ArrayList<ConstraintViolation.PathNode> subPath = new ArrayList<ConstraintViolation.PathNode>(path);
                    subPath.add(new ConstraintViolation.PathNode(child.getField()));
                    violations.addAll(this.validateAnyTypeProperty(schema, subPath, child, dirtyOnly, true));
                }
            }
        }
        return violations;
    }

    private List<ConstraintViolation> validateListTypeProperty(Schema schema, List<ConstraintViolation.PathNode> path, Property prop, boolean dirtyOnly) {
        ArrayList<ConstraintViolation> violations;
        block13: {
            Serializable value;
            Field field;
            block12: {
                field = prop.getField();
                assert (field.getType().isListType());
                violations = new ArrayList<ConstraintViolation>();
                value = prop.getValue();
                if (!prop.isPhantom() && value != null) break block12;
                if (field.isNillable()) break block13;
                this.addNotNullViolation(violations, schema, path);
                break block13;
            }
            List<Object> castedValue = null;
            if (value instanceof Collection) {
                castedValue = (List<Object>)((Object)value);
            } else if (value instanceof Object[]) {
                castedValue = Arrays.asList((Object[])value);
            }
            if (castedValue != null) {
                int index = 0;
                if (prop instanceof ArrayProperty) {
                    if (!field.isNillable() && castedValue.isEmpty()) {
                        this.addNotNullViolation(violations, schema, path);
                    }
                    ArrayProperty arrayProp = (ArrayProperty)prop;
                    for (Object e : castedValue) {
                        if (!dirtyOnly || arrayProp.isDirty(index)) {
                            ArrayList<ConstraintViolation.PathNode> subPath = new ArrayList<ConstraintViolation.PathNode>(path);
                            subPath.add(new ConstraintViolation.PathNode(field, index));
                            violations.addAll(this.validateSimpleTypeField(schema, subPath, field, e));
                        }
                        ++index;
                    }
                } else {
                    Collection<Property> children = prop.getChildren();
                    if (!field.isNillable() && children.isEmpty()) {
                        this.addNotNullViolation(violations, schema, path);
                    }
                    for (Property property : children) {
                        ArrayList<ConstraintViolation.PathNode> subPath = new ArrayList<ConstraintViolation.PathNode>(path);
                        subPath.add(new ConstraintViolation.PathNode(property.getField(), index));
                        violations.addAll(this.validateAnyTypeProperty(schema, subPath, property, dirtyOnly, true));
                        ++index;
                    }
                }
            }
        }
        return violations;
    }

    private void addNotNullViolation(List<ConstraintViolation> violations, Schema schema, List<ConstraintViolation.PathNode> fieldPath) {
        NotNullConstraint constraint = NotNullConstraint.get();
        ConstraintViolation violation = new ConstraintViolation(schema, fieldPath, (Constraint)constraint, null);
        violations.add(violation);
    }
}

