/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.util.PageProviderHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.api.QuickFilter;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="query")
public class QueryObject
extends AbstractResource<ResourceTypeImpl> {
    public static final String PATH = "query";
    public static final String NXQL = "NXQL";
    public static final String QUERY = "query";
    public static final String PAGE_SIZE = "pageSize";
    public static final String CURRENT_PAGE_INDEX = "currentPageIndex";
    public static final String MAX_RESULTS = "maxResults";
    public static final String SORT_BY = "sortBy";
    public static final String SORT_ORDER = "sortOrder";
    public static final String ORDERED_PARAMS = "queryParams";
    public static final String CURRENT_USERID_PATTERN = "$currentUser";
    public static final String CURRENT_REPO_PATTERN = "$currentRepository";
    public static final String QUICK_FILTERS = "quickFilters";
    protected EnumMap<QueryParams, String> queryParametersMap;
    protected EnumMap<LangParams, String> langPathMap;
    protected PageProviderService pageProviderService;

    public void initialize(Object ... args) {
        this.pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        this.queryParametersMap = new EnumMap(QueryParams.class);
        this.queryParametersMap.put(QueryParams.PAGE_SIZE, PAGE_SIZE);
        this.queryParametersMap.put(QueryParams.CURRENT_PAGE_INDEX, CURRENT_PAGE_INDEX);
        this.queryParametersMap.put(QueryParams.MAX_RESULTS, MAX_RESULTS);
        this.queryParametersMap.put(QueryParams.SORT_BY, SORT_BY);
        this.queryParametersMap.put(QueryParams.SORT_ORDER, SORT_ORDER);
        this.queryParametersMap.put(QueryParams.QUERY, "query");
        this.queryParametersMap.put(QueryParams.ORDERED_PARAMS, ORDERED_PARAMS);
        this.queryParametersMap.put(QueryParams.QUICK_FILTERS, QUICK_FILTERS);
        this.langPathMap = new EnumMap(LangParams.class);
        this.langPathMap.put(LangParams.NXQL, NXQL);
    }

    protected DocumentModelList getQuery(UriInfo uriInfo, String langOrProviderName) {
        PaginableDocumentModelListImpl res;
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        String providerName = null;
        if (!this.langPathMap.containsValue(langOrProviderName)) {
            providerName = langOrProviderName;
        }
        String query = (String)queryParams.getFirst((Object)"query");
        String pageSize = (String)queryParams.getFirst((Object)PAGE_SIZE);
        String currentPageIndex = (String)queryParams.getFirst((Object)CURRENT_PAGE_INDEX);
        String maxResults = (String)queryParams.getFirst((Object)MAX_RESULTS);
        String sortBy = (String)queryParams.getFirst((Object)SORT_BY);
        String sortOrder = (String)queryParams.getFirst((Object)SORT_ORDER);
        List orderedParams = (List)queryParams.get((Object)ORDERED_PARAMS);
        String quickFilters = (String)queryParams.getFirst((Object)QUICK_FILTERS);
        if (query == null && StringUtils.isBlank((CharSequence)providerName)) {
            query = "SELECT * from Document";
        }
        Properties namedParameters = new Properties();
        for (String namedParameterKey : queryParams.keySet()) {
            if (this.queryParametersMap.containsValue(namedParameterKey)) continue;
            String value = (String)queryParams.getFirst((Object)namedParameterKey);
            if (value != null) {
                if (value.equals(CURRENT_USERID_PATTERN)) {
                    value = this.ctx.getCoreSession().getPrincipal().getName();
                } else if (value.equals(CURRENT_REPO_PATTERN)) {
                    value = this.ctx.getCoreSession().getRepositoryName();
                }
            }
            namedParameters.put((Object)namedParameterKey, (Object)value);
        }
        Long targetPage = null;
        if (currentPageIndex != null) {
            targetPage = Long.valueOf(currentPageIndex);
        }
        Long targetPageSize = null;
        if (pageSize != null) {
            targetPageSize = Long.valueOf(pageSize);
        }
        Object[] parameters = null;
        if (orderedParams != null && !orderedParams.isEmpty()) {
            parameters = orderedParams.toArray(new String[orderedParams.size()]);
            for (int idx = 0; idx < parameters.length; ++idx) {
                String value = parameters[idx];
                if (value.equals(CURRENT_USERID_PATTERN)) {
                    parameters[idx] = this.ctx.getCoreSession().getPrincipal().getName();
                    continue;
                }
                if (!value.equals(CURRENT_REPO_PATTERN)) continue;
                parameters[idx] = this.ctx.getCoreSession().getRepositoryName();
            }
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.ctx.getCoreSession());
        DocumentModel searchDocumentModel = PageProviderHelper.getSearchDocumentModel((CoreSession)this.ctx.getCoreSession(), (PageProviderService)this.pageProviderService, (String)providerName, (Map)namedParameters);
        ArrayList<SortInfo> sortInfoList = null;
        if (!StringUtils.isBlank((CharSequence)sortBy)) {
            sortInfoList = new ArrayList<SortInfo>();
            String[] sorts = sortBy.split(",");
            String[] orders = null;
            if (!StringUtils.isBlank((CharSequence)sortOrder)) {
                orders = sortOrder.split(",");
            }
            for (int i = 0; i < sorts.length; ++i) {
                String sort = sorts[i];
                boolean sortAscending = orders != null && orders.length > i && "asc".equals(orders[i].toLowerCase());
                sortInfoList.add(new SortInfo(sort, sortAscending));
            }
        }
        if (query != null) {
            PageProviderDefinition ppdefinition = this.pageProviderService.getPageProviderDefinition("REST_API_SEARCH_ADAPTER");
            ppdefinition.setPattern(query);
            if (maxResults != null && !maxResults.isEmpty() && !maxResults.equals("-1")) {
                ppdefinition.getProperties().put(MAX_RESULTS, maxResults);
            }
            if (StringUtils.isBlank((CharSequence)providerName)) {
                providerName = "REST_API_SEARCH_ADAPTER";
            }
            res = new PaginableDocumentModelListImpl(this.pageProviderService.getPageProvider(providerName, ppdefinition, searchDocumentModel, sortInfoList, targetPageSize, targetPage, props, parameters), null);
        } else {
            PageProviderDefinition pageProviderDefinition = this.pageProviderService.getPageProviderDefinition(providerName);
            ArrayList<QuickFilter> quickFilterList = new ArrayList<QuickFilter>();
            if (quickFilters != null && !quickFilters.isEmpty()) {
                String[] filters = quickFilters.split(",");
                List ppQuickFilters = pageProviderDefinition.getQuickFilters();
                block3: for (String filter : filters) {
                    for (QuickFilter quickFilter : ppQuickFilters) {
                        if (!quickFilter.getName().equals(filter)) continue;
                        quickFilterList.add(quickFilter);
                        continue block3;
                    }
                }
            }
            res = new PaginableDocumentModelListImpl(this.pageProviderService.getPageProvider(providerName, searchDocumentModel, sortInfoList, targetPageSize, targetPage, props, quickFilterList, parameters), null);
        }
        if (res.hasError()) {
            throw new NuxeoException(res.getErrorMessage(), 400);
        }
        return res;
    }

    @Deprecated
    protected DocumentModel getSearchDocumentModel(CoreSession session, PageProviderService pps, String providerName, Properties namedParameters) {
        return PageProviderHelper.getSearchDocumentModel((CoreSession)session, (PageProviderService)pps, (String)providerName, (Map)namedParameters);
    }

    @GET
    public Object doQuery(@Context UriInfo uriInfo) {
        return this.getQuery(uriInfo, NXQL);
    }

    @GET
    @Path(value="{langOrProviderName}")
    public Object doSpecificQuery(@Context UriInfo uriInfo, @PathParam(value="langOrProviderName") String langOrProviderName) {
        return this.getQuery(uriInfo, langOrProviderName);
    }

    public static enum LangParams {
        NXQL;

    }

    public static enum QueryParams {
        PAGE_SIZE,
        CURRENT_PAGE_INDEX,
        MAX_RESULTS,
        SORT_BY,
        SORT_ORDER,
        ORDERED_PARAMS,
        QUERY,
        QUICK_FILTERS;

    }
}

