/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.enrichers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class HasContentJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "hasContent";
    public static final String FETCH_CHILD_QUERY = "SELECT * FROM Document WHERE ecm:mixinType != 'HiddenInNavigation' AND ecm:isTrashed = 0 AND ecm:parentId = %s";
    public static final String FETCH_MEMBERS_QUERY = "SELECT * FROM Document WHERE ecm:mixinType != 'HiddenInNavigation' AND ecm:isTrashed = 0 AND collectionMember:collectionIds/* = %s";

    public HasContentJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        if (document.isFolder()) {
            jg.writeBooleanField(NAME, this.hasContent(document, FETCH_CHILD_QUERY));
        } else if (((CollectionManager)Framework.getService(CollectionManager.class)).isCollection(document)) {
            jg.writeBooleanField(NAME, this.hasContent(document, FETCH_MEMBERS_QUERY));
        } else {
            jg.writeBooleanField(NAME, false);
        }
    }

    protected boolean hasContent(DocumentModel document, String query) throws IOException {
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            if (!wrapper.getSession().exists(document.getRef())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = wrapper.getSession().queryProjection(String.format(query, NXQL.escapeString((String)document.getId())), 1L, 0L).size() > 0;
            return bl;
        }
    }
}

