/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.api.operation;

import java.io.IOException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;

@Operation(id="Workflow.SetWorkflowVariables", category="Workflow Context", label="Set workflow variables", requires="Workflow", description="Set a list of variable on the workflow instance with the given id.The variables are specified as <i>key=value</i> pairs separated by a new line. The key used for a variable is the property xpath.The xpath is given by the prefix of the schema storing the variables (in the \"Workflow Variables\" tab) and the variable name.To specify multi-line values you can use a \\ character followed by a new line. <p>Example:<pre>dc:title=The Document Title<br>dc:description=foo bar</pre>For updating a date, you will need to expose the value as ISO 8601 format, for instance : <p>Example:<pre>dc:title=The Document Title<br>dc:issued=@{org.nuxeo.ecm.core.schema.utils.DateParser.formatW3CDateTime(CurrentDate.date)}</pre><p>")
public class SetWorkflowVariablesOperation {
    public static final String ID = "Workflow.SetWorkflowVariables";
    @Context
    protected CoreSession session;
    @Param(name="id", required=true)
    protected String id;
    @Param(name="properties", required=true)
    protected Properties properties;

    @OperationMethod
    public void run() {
        DocumentModel workflowInstance = this.session.getDocument((DocumentRef)new IdRef(this.id));
        try {
            DocumentHelper.setProperties((CoreSession)this.session, (DocumentModel)workflowInstance, (Properties)this.properties);
        }
        catch (PropertyException e) {
            e.addInfo("Cannot set properties on workflow instance with the id: " + this.id);
            throw e;
        }
        catch (IOException e) {
            throw new NuxeoException("Cannot set properties on workflow instance with the id: " + this.id, (Throwable)e);
        }
    }
}

