/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.api.scripting;

import java.util.Calendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;

public class RoutingScriptingFunctions {
    private static final Logger log = LogManager.getLogger(RoutingScriptingFunctions.class);
    public static final String BINDING_KEY = "WorkflowFn";
    protected GraphNode.EscalationRule rule;
    protected OperationContext ctx;

    public RoutingScriptingFunctions(OperationContext ctx) {
        this.ctx = ctx;
    }

    public RoutingScriptingFunctions(OperationContext ctx, GraphNode.EscalationRule rule) {
        this.ctx = ctx;
        this.rule = rule;
    }

    public long timeSinceWorkflowWasStarted() {
        return Calendar.getInstance().getTimeInMillis() - ((Calendar)this.ctx.get((Object)"workflowStartTime")).getTimeInMillis();
    }

    public long timeSinceTaskWasStarted() {
        return Calendar.getInstance().getTimeInMillis() - ((Calendar)this.ctx.get((Object)"nodeStartTime")).getTimeInMillis();
    }

    public long timeSinceDueDateIsOver() {
        return Calendar.getInstance().getTimeInMillis() - ((Calendar)this.ctx.get((Object)"taskDueTime")).getTimeInMillis();
    }

    public long timeSinceRuleHasBeenFalse() {
        if (this.rule == null) {
            throw new NuxeoException("No escalation rule available in this context");
        }
        Calendar lastExecutionTime = this.rule.getLastExecutionTime();
        if (lastExecutionTime == null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = this.rule::getId;
            log.debug("Trying to evaluate timeSinceRuleHasBeenFalse() for the rule: {} that hasn't been executed yet", supplierArray);
            return -1L;
        }
        if (!this.rule.isExecuted()) {
            log.debug("Rule: {} was never executed. Use with {} ruleAlreadyExecuted().", (Object)this.rule.getId(), (Object)BINDING_KEY);
            return -1L;
        }
        return Calendar.getInstance().getTimeInMillis() - this.rule.getLastExecutionTime().getTimeInMillis();
    }

    public boolean ruleAlreadyExecuted() {
        if (this.rule == null) {
            throw new NuxeoException("No escalation rule available in this context");
        }
        return this.rule.isExecuted();
    }
}

