/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.audit;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.query.sql.model.Predicates;
import org.nuxeo.ecm.platform.audit.api.AuditQueryBuilder;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.Logs;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.runtime.api.Framework;

public final class RoutingAuditHelper {
    public static final String TIME_SINCE_WF_STARTED = "timeSinceWfStarted";
    public static final String TIME_SINCE_TASK_STARTED = "timeSinceTaskStarted";
    public static final String TASK_ACTOR = "taskActor";
    public static final String WORKFLOW_INITATIOR = "workflowInitiator";
    public static final String WORKFLOW_VARIABLES = "workflowVariables";

    public static long computeElapsedTime(DocumentRoutingConstants.Events event, String elementId) {
        List logEntries;
        Logs logs = (Logs)Framework.getService(Logs.class);
        if (logs != null && StringUtils.isNotBlank((CharSequence)elementId) && (logEntries = logs.queryLogs(new AuditQueryBuilder().predicate(Predicates.eq((String)"docUUID", (Object)elementId)).and(Predicates.eq((String)"category", (Object)"Routing")).and(Predicates.eq((String)"eventId", (Object)event.name())).defaultOrder().limit(1L))).size() > 0) {
            LogEntry logEntry = (LogEntry)logEntries.get(0);
            Date start = logEntry.getEventDate();
            return new Date().getTime() - start.getTime();
        }
        return -1L;
    }

    public static long computeDurationSinceWfStarted(String workflowInstanceId) {
        return RoutingAuditHelper.computeElapsedTime(DocumentRoutingConstants.Events.afterWorkflowStarted, workflowInstanceId);
    }

    public static long computeDurationSinceTaskStarted(String taskId) {
        return RoutingAuditHelper.computeElapsedTime(DocumentRoutingConstants.Events.afterWorkflowTaskCreated, taskId);
    }
}

