/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.bulk;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEscalationService;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class DocumentRoutingEscalationAction
implements StreamProcessorTopology {
    public static final String ACTION_NAME = "documentRoutingEscalation";
    public static final String ACTION_FULL_NAME = "bulk/documentRoutingEscalation";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(DocumentRoutingEscalationComputation::new, List.of("i1:bulk/documentRoutingEscalation", "o1:bulk/status")).build();
    }

    public static class DocumentRoutingEscalationComputation
    extends AbstractBulkComputation {
        private static final Logger log = LogManager.getLogger(DocumentRoutingEscalationComputation.class);

        public DocumentRoutingEscalationComputation() {
            super(DocumentRoutingEscalationAction.ACTION_FULL_NAME);
        }

        public void startBucket(String bucketKey) {
            ((DocumentRoutingEscalationService)Framework.getService(DocumentRoutingEscalationService.class)).setExecutionRunning(this.command.getRepository());
        }

        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            DocumentRoutingEscalationService escalationService = (DocumentRoutingEscalationService)Framework.getService(DocumentRoutingEscalationService.class);
            for (DocumentModel doc : this.loadDocuments(session, ids)) {
                GraphNode node = (GraphNode)doc.getAdapter(GraphNode.class);
                try {
                    for (GraphNode.EscalationRule rule : escalationService.computeEscalationRulesToExecute(node, false)) {
                        escalationService.executeEscalationRule(rule, false);
                    }
                    session.saveDocument(doc);
                }
                catch (DocumentRouteException e) {
                    log.error("Unable to execute escalation rules on node: {}, skip it", (Object)node, (Object)e);
                    this.delta.inError(String.format("Cannot execute escalation rules on node: %s, %s", node, e.getMessage()));
                }
            }
        }
    }
}

