/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.bulk;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class GarbageCollectRoutesAction
implements StreamProcessorTopology {
    private static final Logger log = LogManager.getLogger(GarbageCollectRoutesAction.class);
    public static final String ACTION_NAME = "garbageCollectWokflows";
    public static final String ACTION_FULL_NAME = "bulk/garbageCollectWokflows";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(GarbageCollectRoutesComputation::new, Arrays.asList("i1:bulk/garbageCollectWokflows", "o1:bulk/status")).build();
    }

    public static class GarbageCollectRoutesComputation
    extends AbstractBulkComputation {
        public GarbageCollectRoutesComputation() {
            super(GarbageCollectRoutesAction.ACTION_FULL_NAME);
        }

        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            DocumentRoutingService routingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
            for (DocumentModel docModel : this.loadDocuments(session, ids)) {
                if (!"DocumentRoute".equals(docModel.getType())) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = () -> ((DocumentModel)docModel).getId();
                    log.debug("Document: {} is not a route", supplierArray);
                    continue;
                }
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((DocumentModel)docModel).getId();
                log.debug("Trying to remove route: {}", supplierArray);
                routingService.purgeDocumentRoute(session, (DocumentRoute)docModel.getAdapter(DocumentRoute.class));
            }
        }
    }
}

