/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteStep;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.routing.core.impl.ElementRunner;
import org.nuxeo.ecm.platform.routing.core.impl.EventFirer;
import org.nuxeo.runtime.api.Framework;

public class DocumentRouteElementImpl
implements DocumentRouteElement,
DocumentRouteStep {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(DocumentRouteElementImpl.class);
    protected DocumentModel document;
    protected ElementRunner runner;

    public DocumentRouteElementImpl(DocumentModel doc, ElementRunner runner) {
        this.document = doc;
        this.runner = runner;
    }

    public DocumentModelList getAttachedDocuments(CoreSession session) {
        List docIds = this.getDocumentRoute(session).getAttachedDocuments();
        ArrayList<IdRef> refs = new ArrayList<IdRef>();
        for (String id : docIds) {
            IdRef idRef = new IdRef(id);
            if (!session.exists((DocumentRef)idRef)) continue;
            refs.add(idRef);
        }
        return session.getDocuments(refs.toArray(new DocumentRef[0]));
    }

    public void run(CoreSession session) {
        this.runner.run(session, this);
    }

    public void run(CoreSession session, Map<String, Serializable> map) {
        this.runner.run(session, this, map);
    }

    public void resume(CoreSession session, String nodeId, String taskId, Map<String, Object> data, String status) {
        this.runner.resume(session, this, nodeId, taskId, data, status);
    }

    public DocumentRoute getDocumentRoute(CoreSession session) {
        DocumentModel parent = this.document;
        while (true) {
            if (parent == null) {
                log.error("NTS: cannot find document route for " + this.document.getId());
            }
            if (parent.hasFacet("DocumentRoute")) break;
            parent = session.getParentDocument(parent.getRef());
        }
        return (DocumentRoute)parent.getAdapter(DocumentRoute.class);
    }

    public DocumentModel getDocument() {
        return this.document;
    }

    protected Object getProperty(String propertyName) {
        return this.document.getPropertyValue(propertyName);
    }

    public String getName() {
        return this.getDocument().getName();
    }

    public String getTitle() {
        return (String)this.getProperty("dc:title");
    }

    public boolean isValidated() {
        return this.checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState.validated);
    }

    public boolean isReady() {
        return this.checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState.ready);
    }

    public boolean isDone() {
        return this.checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState.done);
    }

    protected boolean checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState state) {
        return this.document.getCurrentLifeCycleState().equalsIgnoreCase(state.name());
    }

    public String getDescription() {
        return (String)this.getProperty("dc:description");
    }

    public boolean isRunning() {
        return this.checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState.running);
    }

    public boolean isCanceled() {
        return this.checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState.canceled);
    }

    public boolean isDraft() {
        return this.checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState.draft);
    }

    public void setRunning(CoreSession session) {
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toRunning, session, false);
    }

    public void followTransition(DocumentRouteElement.ElementLifeCycleTransistion transition, CoreSession session, boolean recursive) {
        if (this.document.followTransition(transition.name())) {
            if (Framework.isTestModeSet()) {
                session.save();
            }
            this.document = session.getDocument(this.document.getRef());
        }
        if (recursive) {
            DocumentModelList children = session.getChildren(this.document.getRef());
            for (DocumentModel child : children) {
                DocumentRouteElement element = (DocumentRouteElement)child.getAdapter(DocumentRouteElement.class);
                element.followTransition(transition, session, recursive);
            }
        }
    }

    public void save(CoreSession session) {
        session.saveDocument(this.document);
    }

    public void setDone(CoreSession session) {
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toDone, session, false);
        EventFirer.fireEvent(session, this, null, DocumentRoutingConstants.Events.afterStepRunning.name());
    }

    public void setValidated(CoreSession session) {
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toValidated, session, true);
    }

    public void setReady(CoreSession session) {
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toReady, session, true);
    }

    public void validate(CoreSession session) {
        this.setValidated(session);
        this.setReadOnly(session);
    }

    public void setReadOnly(CoreSession session) {
        SetDocumentOnReadOnlyUnrestrictedSessionRunner readOnlySetter = new SetDocumentOnReadOnlyUnrestrictedSessionRunner(session, this.document.getRef());
        readOnlySetter.runUnrestricted();
    }

    public boolean canValidateStep(CoreSession session) {
        return this.hasPermissionOnDocument(session, "WriteLifeCycle");
    }

    protected boolean hasPermissionOnDocument(CoreSession session, String permission) {
        return session.hasPermission(this.document.getRef(), permission);
    }

    public void setCanValidateStep(CoreSession session, String userOrGroup) {
        this.setPermissionOnDocument(session, userOrGroup, "WriteLifeCycle");
    }

    protected void setPermissionOnDocument(CoreSession session, String userOrGroup, String permission) {
        ACP acp = this.document.getACP();
        ACL routingACL = acp.getOrCreateACL("routing");
        routingACL.add(new ACE(userOrGroup, permission, true));
        this.document.setACP(acp, true);
        session.saveDocument(this.document);
    }

    public boolean canUpdateStep(CoreSession session) {
        return this.hasPermissionOnDocument(session, "WriteProperties");
    }

    public void setCanUpdateStep(CoreSession session, String userOrGroup) {
        this.setPermissionOnDocument(session, userOrGroup, "WriteProperties");
    }

    public void setCanReadStep(CoreSession session, String userOrGroup) {
        this.setPermissionOnDocument(session, userOrGroup, "Read");
    }

    public boolean canDeleteStep(CoreSession session) {
        return this.hasPermissionOnDocument(session, "Remove");
    }

    public void setCanDeleteStep(CoreSession session, String userOrGroup) {
        this.setPermissionOnDocument(session, userOrGroup, "Remove");
    }

    public void backToReady(CoreSession session) {
        EventFirer.fireEvent(session, this, null, DocumentRoutingConstants.Events.beforeStepBackToReady.name());
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.backToReady, session, false);
        EventFirer.fireEvent(session, this, null, DocumentRoutingConstants.Events.afterStepBackToReady.name());
    }

    public boolean canUndoStep(CoreSession session) {
        GetIsParentRunningUnrestricted runner = new GetIsParentRunningUnrestricted(session);
        runner.runUnrestricted();
        return runner.isRunning();
    }

    public void cancel(CoreSession session) {
        this.runner.cancel(session, this);
    }

    public void setCanceled(CoreSession session) {
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toCanceled, session, false);
    }

    public boolean isModifiable() {
        return this.isDraft() || this.isReady() || this.isRunning();
    }

    protected class SetDocumentOnReadOnlyUnrestrictedSessionRunner
    extends UnrestrictedSessionRunner {
        protected DocumentRef ref;

        public SetDocumentOnReadOnlyUnrestrictedSessionRunner(CoreSession session, DocumentRef ref) {
            super(session);
            this.ref = ref;
        }

        public void run() {
            DocumentModel doc = this.session.getDocument(this.ref);
            ACPImpl acp = new ACPImpl();
            ACL routingACL = acp.getOrCreateACL("routing");
            routingACL.add(new ACE("Everyone", "Read", true));
            ACL localACL = acp.getOrCreateACL("local");
            localACL.add(new ACE("Everyone", "Everything", false));
            doc.setACP((ACP)acp, true);
            this.session.saveDocument(doc);
        }
    }

    protected class GetIsParentRunningUnrestricted
    extends UnrestrictedSessionRunner {
        protected boolean isRunning;

        public GetIsParentRunningUnrestricted(CoreSession session) {
            super(session);
        }

        public void run() {
            DocumentModel parent = this.session.getDocument(DocumentRouteElementImpl.this.document.getParentRef());
            DocumentRouteElement parentElement = (DocumentRouteElement)parent.getAdapter(DocumentRouteElement.class);
            this.isRunning = parentElement.isRunning();
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }
}

