/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEngineService;
import org.nuxeo.ecm.platform.routing.core.impl.EventFirer;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocumentRoutingEngineServiceImpl
extends DefaultComponent
implements DocumentRoutingEngineService {
    public static final String WORKFLOW_NAME_EVENT_PROPERTY_KEY = "wfName";
    public static final String WORKFLOW_ID_EVENT_PROPERTY_KEY = "wfId";

    @Override
    public void start(DocumentRoute routeInstance, Map<String, Serializable> map, CoreSession session) {
        routeInstance.run(session, map);
    }

    @Override
    public void resume(DocumentRoute routeInstance, String nodeId, String taskId, Map<String, Object> data, String status, CoreSession session) {
        routeInstance.resume(session, nodeId, taskId, data, status);
    }

    @Override
    public void cancel(DocumentRoute routeInstance, CoreSession session) {
        final String routeDocId = routeInstance.getDocument().getId();
        new UnrestrictedSessionRunner(session){

            public void run() {
                DocumentModel routeDoc = this.session.getDocument((DocumentRef)new IdRef(routeDocId));
                DocumentRoute routeInstance = (DocumentRoute)routeDoc.getAdapter(DocumentRoute.class);
                if (routeInstance == null) {
                    throw new NuxeoException("Document " + String.valueOf(routeDoc) + " can not be adapted to a DocumentRoute");
                }
                routeInstance.cancel(this.session);
            }
        }.runUnrestricted();
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put(WORKFLOW_NAME_EVENT_PROPERTY_KEY, (Serializable)((Object)routeInstance.getTitle()));
        properties.put(WORKFLOW_ID_EVENT_PROPERTY_KEY, (Serializable)((Object)routeDocId));
        EventFirer.fireEvent(session, (List<DocumentModel>)routeInstance.getAttachedDocuments(session), properties, DocumentRoutingConstants.Events.workflowCanceled.name());
    }
}

