/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEscalationService;
import org.nuxeo.ecm.platform.routing.core.api.scripting.RoutingScriptingExpression;
import org.nuxeo.ecm.platform.routing.core.api.scripting.RoutingScriptingFunctions;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class DocumentRoutingEscalationServiceImpl
implements DocumentRoutingEscalationService {
    private static final Logger log = LogManager.getLogger(DocumentRoutingEscalationServiceImpl.class);
    @Deprecated
    public static final String queryForSuspendedNodesWithEscalation = "SELECT DISTINCT ecm:uuid FROM RouteNode WHERE ecm:currentLifeCycleState = 'suspended' AND ( rnode:escalationRules/*1/executed = 0 OR rnode:escalationRules/*1/multipleExecution = 1 )";
    protected static final String WORKFLOW_ESCALATION_KV_STORE_NAME = "workflowEscalationRunning";
    protected static final String ESCALATION_RUNNING_TTL_KEY = "nuxeo.document.routing.escalation.running.flag.ttl.duration";

    @Override
    @Deprecated
    public List<String> queryForSuspendedNodesWithEscalation(CoreSession session) {
        final ArrayList<String> nodesDocIds = new ArrayList<String>();
        new UnrestrictedSessionRunner(session){

            public void run() {
                IterableQueryResult results = this.session.queryAndFetch(DocumentRoutingEscalationServiceImpl.queryForSuspendedNodesWithEscalation, "NXQL", new Object[0]);
                for (Map result : results) {
                    nodesDocIds.add(((Serializable)result.get("ecm:uuid")).toString());
                    log.trace("Inspecting node for escalation rules: {}", result.get("ecm:uuid"));
                }
                results.close();
            }
        }.runUnrestricted();
        return nodesDocIds;
    }

    @Override
    public boolean isExecutionRunning(String repositoryName) {
        KeyValueStore kvStore = DocumentRoutingEscalationServiceImpl.getKvStore();
        return Boolean.TRUE.toString().equals(kvStore.getString(repositoryName));
    }

    @Override
    public void setExecutionRunning(String repositoryName) {
        KeyValueStore kvStore = DocumentRoutingEscalationServiceImpl.getKvStore();
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        kvStore.put(repositoryName, Boolean.TRUE.toString(), configurationService.getDuration(ESCALATION_RUNNING_TTL_KEY, Duration.ofMinutes(3L)).toSeconds());
    }

    protected static KeyValueStore getKvStore() {
        return ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore(WORKFLOW_ESCALATION_KV_STORE_NAME);
    }

    @Override
    public List<GraphNode.EscalationRule> computeEscalationRulesToExecute(GraphNode node, boolean handleTransaction) {
        CoreSession session = node.getDocument().getCoreSession();
        ArrayList<GraphNode.EscalationRule> rulesToExecute = new ArrayList<GraphNode.EscalationRule>();
        for (GraphNode.EscalationRule rule : node.getEscalationRules()) {
            try {
                OperationContext context = this.getExecutionContext(session, node, handleTransaction);
                try {
                    RoutingScriptingExpression expr = new RoutingScriptingExpression(rule.getCondition(), new RoutingScriptingFunctions(context, rule));
                    Object res = expr.eval(context);
                    if (!(res instanceof Boolean)) {
                        throw new DocumentRouteException(String.format("Condition for rule: %s of node: %s of graph: %s does not evaluate to a boolean: %s", rule, node.getId(), node.getGraph().getName(), rule.getCondition()));
                    }
                    boolean bool = Boolean.TRUE.equals(res);
                    if (rule.isExecuted() && !rule.isMultipleExecution() || !bool) continue;
                    rulesToExecute.add(rule);
                }
                finally {
                    if (context == null) continue;
                    context.close();
                }
            }
            catch (DocumentRouteException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new DocumentRouteException("Error evaluating condition: " + rule.getCondition(), (Throwable)e);
            }
        }
        if (handleTransaction) {
            session.saveDocument(node.getDocument());
        }
        return rulesToExecute;
    }

    @Override
    public void executeEscalationRule(GraphNode.EscalationRule rule, boolean handleTransaction) {
        GraphNode node = rule.getNode();
        DocumentModel nodeDoc = node.getDocument();
        CoreSession session = nodeDoc.getCoreSession();
        try (OperationContext context = this.getExecutionContext(session, node, handleTransaction);){
            AutomationService automationService = (AutomationService)Framework.getService(AutomationService.class);
            automationService.run(context, rule.getChain());
            node.setAllVariables((Map<String, Object>)context, true, handleTransaction);
            rule.setExecuted(true);
            if (handleTransaction) {
                session.saveDocument(nodeDoc);
            }
        }
        catch (OperationException e) {
            throw new DocumentRouteException(String.format("Error when running chain: %s from escalation rule: %s of node: %s", rule.getChain(), rule, node.getId()), (Throwable)e);
        }
    }

    protected OperationContext getExecutionContext(CoreSession session, GraphNode node, boolean handleTransaction) {
        OperationContext context = new OperationContext(session);
        context.putAll(node.getWorkflowContextualInfo(session, true));
        context.handleTransaction(handleTransaction);
        context.setInput(context.get((Object)"documents"));
        return context;
    }

    @Override
    @Deprecated
    public void scheduleExecution(GraphNode.EscalationRule rule, CoreSession session) {
        WorkManager manager = (WorkManager)Framework.getService(WorkManager.class);
        manager.schedule((Work)new EscalationRuleWork(rule.getId(), rule.getNode().getDocument().getId(), session.getRepositoryName()), WorkManager.Scheduling.IF_NOT_SCHEDULED);
    }

    @Deprecated
    private static void markRuleAsExecuted(String nodeDocId, String escalationRuleId, CoreSession session) {
        DocumentModel nodeDoc = session.getDocument((DocumentRef)new IdRef(nodeDocId));
        GraphNode node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
        List<GraphNode.EscalationRule> rules = node.getEscalationRules();
        for (GraphNode.EscalationRule escalationRule : rules) {
            if (!escalationRuleId.equals(escalationRule.getId())) continue;
            escalationRule.setExecuted(true);
            break;
        }
        session.saveDocument(nodeDoc);
    }

    @Deprecated
    public static class EscalationRuleWork
    extends AbstractWork {
        private static final long serialVersionUID = 1L;
        protected String escalationRuleId;
        protected String nodeDocId;
        public static final String CATEGORY = "routingEscalation";

        public EscalationRuleWork(String escalationRuleId, String nodeDocId, String repositoryName) {
            super(repositoryName + ":" + nodeDocId + ":escalationRule:" + escalationRuleId);
            this.repositoryName = repositoryName;
            this.escalationRuleId = escalationRuleId;
            this.nodeDocId = nodeDocId;
        }

        public String getTitle() {
            return this.getId();
        }

        public String getCategory() {
            return CATEGORY;
        }

        public int getRetryCount() {
            return 2;
        }

        public boolean isIdempotent() {
            return false;
        }

        public void work() {
            this.openSystemSession();
            DocumentModel nodeDoc = this.session.getDocument((DocumentRef)new IdRef(this.nodeDocId));
            GraphNode node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
            if (node == null) {
                throw new NuxeoException("Can't execute worker '" + this.getId() + "' : the document '" + this.nodeDocId + "' can not be adapted to a GraphNode");
            }
            List<GraphNode.EscalationRule> rules = node.getEscalationRules();
            GraphNode.EscalationRule rule = null;
            for (GraphNode.EscalationRule escalationRule : rules) {
                if (!this.escalationRuleId.equals(escalationRule.getId())) continue;
                rule = escalationRule;
                break;
            }
            if (rule == null) {
                throw new NuxeoException("Can't execute worker '" + this.getId() + "' : the rule '" + this.escalationRuleId + "' was not found on the node '" + this.nodeDocId + "'");
            }
            boolean alreadyExecuted = this.getExecutionStatus(rule, this.session);
            if (alreadyExecuted && !rule.isMultipleExecution()) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = rule::getId;
                supplierArray[1] = node::getId;
                log.trace("Rule: {} on node: {} already executed", supplierArray);
                return;
            }
            ((DocumentRoutingEscalationService)Framework.getService(DocumentRoutingEscalationService.class)).executeEscalationRule(rule);
            DocumentRoutingEscalationServiceImpl.markRuleAsExecuted(this.nodeDocId, this.escalationRuleId, this.session);
        }

        public boolean getExecutionStatus(GraphNode.EscalationRule rule, CoreSession session) {
            DocumentModel nodeDoc = session.getDocument((DocumentRef)new IdRef(rule.getNode().getDocument().getId()));
            GraphNode node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
            List<GraphNode.EscalationRule> rules = node.getEscalationRules();
            for (GraphNode.EscalationRule escalationRule : rules) {
                if (rule.compareTo(escalationRule) != 0) continue;
                return escalationRule.isExecuted();
            }
            return false;
        }
    }
}

