/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.io.enrichers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class RunnableWorkflowJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "runnableWorkflows";

    public RunnableWorkflowJsonEnricher() {
        super(NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        jg.writeFieldName(NAME);
        jg.writeStartArray();
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            if (!wrapper.getSession().exists(document.getRef())) {
                return;
            }
            DocumentRoutingService documentRoutingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
            List routeModels = documentRoutingService.getRunnableWorkflows(wrapper.getSession(), List.of(document.getId()));
            for (DocumentRoute documentRoute : routeModels) {
                this.writeEntity(documentRoute, jg);
            }
        }
        finally {
            jg.writeEndArray();
        }
    }
}

