/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import java.io.Serializable;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.runtime.api.Framework;

public class DocumentRouteOrphanedListener
implements PostCommitEventListener {
    protected static final String QUERY_GET_RELATED_DOCUMENT_ROUTES = "SELECT * FROM DocumentRoute WHERE docri:participatingDocuments = '%s'";
    protected static final String QUERY_GET_TASKS_RELATED_TO_DOCUMENT_ROUTE = "SELECT ecm:uuid FROM TaskDoc WHERE nt:processId = '%s'";

    public void handleEvent(EventBundle events) {
        for (Event event : events) {
            DocumentEventContext context = (DocumentEventContext)event.getContext();
            DocumentModel docModel = context.getSourceDocument();
            if ("DocumentRoute".equals(docModel.getType())) {
                this.deleteOrphanTasks(context.getCoreSession(), docModel.getId());
                continue;
            }
            if ("RoutingTask".equals(docModel.getType())) continue;
            this.deleteOrphanDocumentRoutes(context.getCoreSession(), docModel.getId());
        }
    }

    protected void deleteOrphanDocumentRoutes(CoreSession session, String id) {
        String query = String.format(QUERY_GET_RELATED_DOCUMENT_ROUTES, id);
        for (DocumentModel doc : session.query(query)) {
            DocumentRoute documentRoute = (DocumentRoute)doc.getAdapter(DocumentRoute.class);
            List attachedDocuments = documentRoute.getAttachedDocuments();
            attachedDocuments.remove(id);
            documentRoute.setAttachedDocuments(attachedDocuments);
            if (attachedDocuments.isEmpty()) {
                ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).purgeDocumentRoute(session, documentRoute);
                continue;
            }
            session.saveDocument(doc);
        }
    }

    protected void deleteOrphanTasks(CoreSession session, String id) {
        String query = String.format(QUERY_GET_TASKS_RELATED_TO_DOCUMENT_ROUTE, id);
        session.queryProjection(query, 0L, 0L).stream().map(m -> (Serializable)m.get("ecm:uuid")).map(taskId -> new IdRef((String)((Object)taskId))).forEach(arg_0 -> ((CoreSession)session).removeDocument(arg_0));
    }
}

