/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEscalationService;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.runtime.api.Framework;

public class DocumentRoutingEscalationListener
implements EventListener {
    private static final Logger log = LogManager.getLogger(DocumentRoutingEscalationListener.class);
    public static final String EXECUTE_ESCALATION_RULE_EVENT = "executeEscalationRules";
    @Deprecated
    public static final String USE_LEGACY_CONF_KEY = "nuxeo.document.routing.escalation.legacy";

    public void handleEvent(Event event) {
        block7: {
            RepositoryManager repositoryManager;
            block6: {
                if (!EXECUTE_ESCALATION_RULE_EVENT.equals(event.getName())) {
                    return;
                }
                repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
                if (!Boolean.parseBoolean(Framework.getProperty((String)USE_LEGACY_CONF_KEY, (String)"false"))) break block6;
                for (String repositoryName : repositoryManager.getRepositoryNames()) {
                    this.triggerEsclationRulesExecution(repositoryName);
                }
                break block7;
            }
            BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
            DocumentRoutingEscalationService escalationService = (DocumentRoutingEscalationService)Framework.getService(DocumentRoutingEscalationService.class);
            if (bulkService == null || escalationService == null) break block7;
            for (String repositoryName : repositoryManager.getRepositoryNames()) {
                if (escalationService.isExecutionRunning(repositoryName)) {
                    log.warn("Not scheduling Workflow Escalation execution on repository: {} because one is already running", (Object)repositoryName);
                    continue;
                }
                BulkCommand command = new BulkCommand.Builder("documentRoutingEscalation", "SELECT DISTINCT ecm:uuid FROM RouteNode WHERE ecm:currentLifeCycleState = 'suspended' AND ( rnode:escalationRules/*1/executed = 0 OR rnode:escalationRules/*1/multipleExecution = 1 )", "system").repository(repositoryName).build();
                try {
                    bulkService.submit(command);
                }
                catch (IllegalStateException e) {
                    log.warn("Not scheduling Workflow Escalation execution on repository: {} because one is already running", (Object)repositoryName);
                }
            }
        }
    }

    @Deprecated
    protected void triggerEsclationRulesExecution(String repositoryName) {
        new UnrestrictedSessionRunner(repositoryName){

            public void run() {
                DocumentRoutingEscalationService escalationService = (DocumentRoutingEscalationService)Framework.getService(DocumentRoutingEscalationService.class);
                List<String> nodeIds = escalationService.queryForSuspendedNodesWithEscalation(this.session);
                for (String id : nodeIds) {
                    DocumentModel nodeDoc = this.session.getDocument((DocumentRef)new IdRef(id));
                    GraphNode node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
                    List<GraphNode.EscalationRule> rules = escalationService.computeEscalationRulesToExecute(node);
                    for (GraphNode.EscalationRule rule : rules) {
                        escalationService.scheduleExecution(rule, this.session);
                    }
                }
            }
        }.runUnrestricted();
    }
}

