/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import java.util.HashSet;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.runtime.api.Framework;

public class DocumentRoutingWorkflowInstancesCleanup
implements PostCommitEventListener {
    public static final String CLEANUP_WORKFLOW_INSTANCES_PROPERTY = "nuxeo.routing.disable.cleanup.workflow.instances";
    public static final String CLEANUP_WORKFLOW_INSTANCES_BATCH_SIZE_PROPERTY = "nuxeo.routing.cleanup.workflow.instances.batch.size";
    public static final String CLEANUP_WORKFLOW_INSTANCES_ORPHAN_PROPERTY = "nuxeo.routing.cleanup.workflow.instances.orphan";
    public static final String CLEANUP_WORKFLOW_REPO_NAME_PROPERTY = "repositoryName";
    public static final String CLEANUP_WORKFLOW_EVENT_NAME = "workflowInstancesCleanup";

    public void handleEvent(EventBundle events) {
        if (Framework.isBooleanPropertyTrue((String)CLEANUP_WORKFLOW_INSTANCES_PROPERTY)) {
            return;
        }
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        DocumentRoutingService routingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        HashSet<String> repositoryNames = new HashSet<String>();
        for (Event event : events) {
            if (event.getContext().hasProperty(CLEANUP_WORKFLOW_REPO_NAME_PROPERTY)) {
                String repositoryName = (String)((Object)event.getContext().getProperty(CLEANUP_WORKFLOW_REPO_NAME_PROPERTY));
                repositoryNames.add(repositoryName);
                continue;
            }
            repositoryNames.addAll(repositoryManager.getRepositoryNames());
        }
        repositoryNames.forEach(repo -> routingService.cleanupRouteInstances(repo));
    }
}

