/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.core.impl.ElementRunner;

public abstract class AbstractRunner
implements ElementRunner {
    protected List<DocumentRouteElement> getChildrenElement(CoreSession session, DocumentRouteElement element) {
        DocumentModelList children = session.getChildren(element.getDocument().getRef());
        ArrayList<DocumentRouteElement> elements = new ArrayList<DocumentRouteElement>();
        for (DocumentModel model : children) {
            elements.add((DocumentRouteElement)model.getAdapter(DocumentRouteElement.class));
        }
        return elements;
    }

    @Override
    public void run(CoreSession session, DocumentRouteElement element, Map<String, Serializable> map) {
        this.run(session, element);
    }

    @Override
    public void resume(CoreSession session, DocumentRouteElement element, String nodeId, String taskId, Map<String, Object> data, String status) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void undo(CoreSession session, DocumentRouteElement element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancel(CoreSession session, DocumentRouteElement element) {
        List<DocumentRouteElement> children = this.getChildrenElement(session, element);
        for (DocumentRouteElement child : children) {
            child.cancel(session);
        }
        element.setCanceled(session);
    }
}

