/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.core.audit.RoutingAuditHelper;
import org.nuxeo.ecm.platform.routing.core.impl.AbstractRunner;
import org.nuxeo.ecm.platform.routing.core.impl.ElementRunner;
import org.nuxeo.ecm.platform.routing.core.impl.EventFirer;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskComment;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.runtime.api.Framework;

public class GraphRunner
extends AbstractRunner
implements ElementRunner,
Serializable {
    private static final Log log = LogFactory.getLog(GraphRunner.class);
    public static final int MAX_LOOPS = 100;

    @Override
    public void run(CoreSession session, DocumentRouteElement element, Map<String, Serializable> map) {
        GraphRoute graph = (GraphRoute)element;
        element.setRunning(session);
        if (map != null) {
            graph.setVariables(map);
        }
        this.runGraph(session, element, graph.getStartNode());
    }

    @Override
    public void run(CoreSession session, DocumentRouteElement element) {
        this.run(session, element, null);
    }

    @Override
    public void resume(CoreSession session, DocumentRouteElement element, String nodeId, String taskId, Map<String, Object> varData, String status) {
        boolean forceResume;
        GraphNode node;
        GraphRoute graph = (GraphRoute)element;
        Task task = null;
        if (taskId == null) {
            if (nodeId == null) {
                throw new DocumentRouteException("nodeId and taskId both missing");
            }
        } else {
            DocumentModel taskDoc = session.getDocument((DocumentRef)new IdRef(taskId));
            task = (Task)taskDoc.getAdapter(Task.class);
            if (task == null) {
                throw new DocumentRouteException("Invalid taskId: " + taskId);
            }
            if (nodeId == null && StringUtils.isEmpty((CharSequence)(nodeId = task.getVariable("nodeId")))) {
                throw new DocumentRouteException("No nodeId found on task: " + taskId);
            }
        }
        if ((node = graph.getNode(nodeId)) == null) {
            throw new DocumentRouteException("Invalid nodeId: " + nodeId);
        }
        boolean bl = forceResume = varData != null && varData.get("_FORCE_RESUME_") != null && (Boolean)varData.get("_FORCE_RESUME_") != false;
        if (forceResume && node.getState() != GraphNode.State.SUSPENDED && node.getState() != GraphNode.State.WAITING) {
            throw new DocumentRouteException("Cannot force resume on non-suspended or non-waiting node: " + node);
        }
        if (!forceResume && node.getState() != GraphNode.State.SUSPENDED) {
            throw new DocumentRouteException("Cannot resume on non-suspended node: " + node);
        }
        node.setAllVariables(varData, false);
        if (StringUtils.isNotEmpty((CharSequence)status)) {
            node.setButton(status);
        }
        if (task != null) {
            this.finishTask(session, graph, node, task, false, status);
            if (task != null) {
                long timeSinceWfStarted;
                HashMap<String, Object> eventProperties = new HashMap<String, Object>();
                eventProperties.put("category", "Routing");
                eventProperties.put("taskName", task.getName());
                eventProperties.put("modelName", graph.getModelName());
                eventProperties.put("action", status);
                eventProperties.put("data", (Serializable)((Object)varData));
                eventProperties.put("workflowInitiator", graph.getInitiator());
                eventProperties.put("taskActor", session.getPrincipal().getActingUser());
                eventProperties.put("nodeVariables", (Serializable)((Object)node.getVariables()));
                eventProperties.put("workflowVariables", (Serializable)((Object)graph.getVariables()));
                long duration = RoutingAuditHelper.computeDurationSinceTaskStarted(task.getId());
                if (duration >= 0L) {
                    eventProperties.put("timeSinceTaskStarted", duration);
                }
                if ((timeSinceWfStarted = RoutingAuditHelper.computeDurationSinceWfStarted(task.getProcessId())) >= 0L) {
                    eventProperties.put("timeSinceWfStarted", timeSinceWfStarted);
                }
                DocumentEventContext envContext = new DocumentEventContext(session, session.getPrincipal(), task.getDocument());
                envContext.setProperties(eventProperties);
                EventProducer eventProducer = (EventProducer)Framework.getService(EventProducer.class);
                eventProducer.fireEvent(envContext.newEvent(DocumentRoutingConstants.Events.afterWorkflowTaskEnded.name()));
            }
        } else {
            node.cancelTasks();
        }
        if (node.hasOpenTasks()) {
            log.info((Object)("Node " + node.getId() + "has open tasks, the workflow can not be resumed for now."));
            if (varData != null && varData.get("NodeVariables") != null && ((Map)varData.get("NodeVariables")).containsKey("comment")) {
                node.setVariable("comment", "");
            }
            return;
        }
        this.runGraph(session, element, node);
    }

    @Override
    public void cancel(CoreSession session, DocumentRouteElement element) {
        GraphRoute graph = element instanceof GraphRoute ? (GraphRoute)element : null;
        HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
        if (graph != null) {
            eventProperties.put("modelId", (Serializable)((Object)graph.getModelId()));
            eventProperties.put("modelName", (Serializable)((Object)graph.getModelName()));
            eventProperties.put("workflowVariables", (Serializable)((Object)graph.getVariables()));
            eventProperties.put("workflowInitiator", (Serializable)((Object)graph.getInitiator()));
            ArrayList<String> pendingNodeNames = new ArrayList<String>();
            for (GraphNode suspendedNode : graph.getSuspendedNodes()) {
                pendingNodeNames.add(suspendedNode.getId());
            }
            eventProperties.put("pendingNodes", pendingNodeNames);
        }
        EventFirer.fireEvent(session, element, eventProperties, DocumentRoutingConstants.Events.beforeWorkflowCanceled.name());
        super.cancel(session, element);
        if (graph == null) {
            return;
        }
        for (GraphNode node : graph.getNodes()) {
            node.cancelTasks();
            node.cancelSubRoute();
        }
    }

    protected void runGraph(CoreSession session, DocumentRouteElement element, GraphNode initialNode) throws DocumentRouteException {
        GraphRoute graph = (GraphRoute)element;
        LinkedList<GraphNode> pendingSubRoutes = new LinkedList<GraphNode>();
        LinkedList<GraphNode> pendingNodes = new LinkedList<GraphNode>();
        pendingNodes.add(initialNode);
        boolean done = false;
        int count = 0;
        while (!pendingNodes.isEmpty()) {
            GraphNode node = (GraphNode)pendingNodes.pop();
            if (++count > 100) {
                throw new DocumentRouteException("Execution is looping, node: " + node);
            }
            GraphNode.State jump = null;
            switch (node.getState()) {
                case READY: {
                    log.debug((Object)("Doing node " + node));
                    if (node.isMerge()) {
                        jump = GraphNode.State.WAITING;
                        break;
                    }
                    jump = GraphNode.State.RUNNING_INPUT;
                    break;
                }
                case WAITING: {
                    if (!node.canMerge()) break;
                    this.recursiveCancelInput(graph, node, pendingNodes);
                    jump = GraphNode.State.RUNNING_INPUT;
                    break;
                }
                case RUNNING_INPUT: {
                    node.starting();
                    node.executeChain(node.getInputChain());
                    if (node.hasTask() || node.hasMultipleTasks()) {
                        this.createTask(session, graph, node);
                        node.setState(GraphNode.State.SUSPENDED);
                    }
                    if (node.hasSubRoute()) {
                        if (!pendingSubRoutes.contains(node)) {
                            pendingSubRoutes.add(node);
                        }
                        node.setState(GraphNode.State.SUSPENDED);
                    }
                    if (node.getState() == GraphNode.State.SUSPENDED) break;
                    jump = GraphNode.State.RUNNING_OUTPUT;
                    break;
                }
                case SUSPENDED: {
                    if (node != initialNode) {
                        throw new DocumentRouteException("Executing unexpected SUSPENDED state");
                    }
                    NuxeoPrincipal principal = session.getPrincipal();
                    String actor = principal.getActingUser();
                    node.setLastActor(actor);
                    jump = GraphNode.State.RUNNING_OUTPUT;
                    break;
                }
                case RUNNING_OUTPUT: {
                    node.executeChain(node.getOutputChain());
                    List<GraphNode.Transition> trueTrans = node.evaluateTransitions();
                    node.ending();
                    node.setState(GraphNode.State.READY);
                    if (node.isStop()) {
                        if (!pendingNodes.isEmpty()) {
                            throw new DocumentRouteException(String.format("Route %s stopped with still pending nodes: %s", graph, pendingNodes));
                        }
                        done = true;
                        break;
                    }
                    if (trueTrans.isEmpty()) {
                        throw new DocumentRouteException("No transition evaluated to true from node " + node);
                    }
                    for (GraphNode.Transition t : trueTrans) {
                        node.executeTransitionChain(t);
                        GraphNode target = graph.getNode(t.target);
                        if (pendingNodes.contains(target)) continue;
                        pendingNodes.add(target);
                    }
                    break;
                }
            }
            if (jump == null) continue;
            node.setState(jump);
            --count;
            pendingNodes.addFirst(node);
        }
        if (done) {
            element.setDone(session);
            if (graph.hasParentRoute()) {
                graph.resumeParentRoute(session);
            }
        }
        for (GraphNode node : pendingSubRoutes) {
            DocumentRoute documentRoute = node.startSubRoute();
        }
        session.save();
    }

    protected void recursiveCancelInput(GraphRoute graph, GraphNode originalNode, LinkedList<GraphNode> pendingNodes) {
        LinkedList<GraphNode> todo = new LinkedList<GraphNode>();
        todo.add(originalNode);
        HashSet<String> done = new HashSet<String>();
        while (!todo.isEmpty()) {
            GraphNode node = (GraphNode)todo.pop();
            done.add(node.getId());
            for (GraphNode.Transition t : node.getInputTransitions()) {
                GraphNode source;
                if (t.loop || done.contains((source = t.source).getId())) continue;
                source.setCanceled();
                GraphNode.State state = source.getState();
                source.setState(GraphNode.State.READY);
                pendingNodes.remove(node);
                if (state == GraphNode.State.SUSPENDED) {
                    source.cancelTasks();
                    continue;
                }
                todo.add(source);
            }
        }
    }

    protected void createTask(CoreSession session, GraphRoute graph, GraphNode node) throws DocumentRouteException {
        GraphRoute routeInstance = graph;
        HashMap<String, String> taskVariables = new HashMap<String, String>();
        taskVariables.put("routeInstanceDocId", routeInstance.getDocument().getId());
        taskVariables.put("nodeId", node.getId());
        taskVariables.put("document.routing.step", node.getDocument().getId());
        String taskNotiftemplate = node.getTaskNotificationTemplate();
        if (!StringUtils.isEmpty((CharSequence)taskNotiftemplate)) {
            taskVariables.put("taskNotificationTemplate", taskNotiftemplate);
        } else {
            taskVariables.put("disableNotificationService", "true");
        }
        LinkedHashSet<String> actors = new LinkedHashSet<String>();
        actors.addAll(node.evaluateTaskAssignees());
        actors.addAll(node.getTaskAssignees());
        Date dueDate = node.computeTaskDueDate();
        DocumentModelList docs = graph.getAttachedDocumentModels();
        TaskService taskService = (TaskService)Framework.getService(TaskService.class);
        DocumentRoutingService routing = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        List tasks = taskService.createTask(session, session.getPrincipal(), (List)docs, node.getTaskDocType(), node.getDocument().getTitle(), node.getId(), routeInstance.getDocument().getId(), new ArrayList(actors), node.hasMultipleTasks(), node.getTaskDirective(), null, dueDate, taskVariables, null, node.getWorkflowContextualInfo(session, true));
        for (Task task : tasks) {
            long timeSinceWfStarted;
            HashMap<String, Object> eventProperties = new HashMap<String, Object>();
            eventProperties.put("category", "Routing");
            eventProperties.put("taskName", node.getDocument().getTitle());
            eventProperties.put("actors", actors);
            eventProperties.put("modelId", graph.getModelId());
            eventProperties.put("modelName", graph.getModelName());
            eventProperties.put("workflowInitiator", graph.getInitiator());
            eventProperties.put("taskActor", session.getPrincipal().getOriginatingUser());
            eventProperties.put("nodeVariables", (Serializable)((Object)node.getVariables()));
            if (routeInstance instanceof GraphRoute) {
                eventProperties.put("workflowVariables", (Serializable)((Object)routeInstance.getVariables()));
            }
            if ((timeSinceWfStarted = RoutingAuditHelper.computeDurationSinceWfStarted(task.getProcessId())) >= 0L) {
                eventProperties.put("timeSinceWfStarted", timeSinceWfStarted);
            }
            DocumentEventContext envContext = new DocumentEventContext(session, session.getPrincipal(), task.getDocument());
            envContext.setProperties(eventProperties);
            EventProducer eventProducer = (EventProducer)Framework.getService(EventProducer.class);
            eventProducer.fireEvent(envContext.newEvent(DocumentRoutingConstants.Events.afterWorkflowTaskCreated.name()));
        }
        for (Task task : tasks) {
            node.addTaskInfo(task.getId());
        }
        String taskAssigneesPermission = node.getTaskAssigneesPermission();
        if (StringUtils.isEmpty((CharSequence)taskAssigneesPermission)) {
            return;
        }
        for (Task task : tasks) {
            routing.grantPermissionToTaskAssignees(session, taskAssigneesPermission, (List)docs, task);
        }
    }

    protected void finishTask(CoreSession session, GraphRoute graph, GraphNode node, Task task, boolean delete) throws DocumentRouteException {
        this.finishTask(session, graph, node, task, delete, null);
    }

    protected void finishTask(CoreSession session, GraphRoute graph, GraphNode node, Task task, boolean delete, String status) throws DocumentRouteException {
        List comments;
        DocumentRoutingService routing = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        DocumentModelList docs = graph.getAttachedDocumentModels();
        routing.removePermissionsForTaskActors(session, (List)docs, task);
        if (delete) {
            session.removeDocument((DocumentRef)new IdRef(task.getId()));
        }
        String comment = (comments = task.getComments()).size() > 0 ? ((TaskComment)comments.get(comments.size() - 1)).getText() : "";
        NuxeoPrincipal principal = session.getPrincipal();
        String actor = principal.getActingUser();
        node.updateTaskInfo(task.getId(), true, status, actor, comment);
    }
}

