/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolverService;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.core.io.DocumentRouteWriter;
import org.nuxeo.ecm.platform.routing.core.io.NodeAccessRunner;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskComment;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class TaskWriter
extends ExtensibleEntityJsonWriter<Task> {
    private static final Logger log = LogManager.getLogger(TaskWriter.class);
    public static final String FETCH_ACTORS = "actors";
    public static final String TARGET_DOCUMENT_IDS = "targetDocumentIds";
    public static final String FETCH_TARGET_DOCUMENT = "targetDocumentIds";
    public static final String FETCH_WORKFLOW_INITATIOR = "workflowInitiator";
    protected static final String USER_PREFIX = "user";
    protected static final String GROUP_PREFIX = "group";
    protected static final String SEPARATOR = ":";
    @Inject
    protected SchemaManager schemaManager;
    @Inject
    protected UserManager userManager;
    public static final String ENTITY_TYPE = "task";

    public TaskWriter() {
        super(ENTITY_TYPE, Task.class);
    }

    public void writeEntityBody(Task item, JsonGenerator jg) throws IOException {
        GraphRoute workflowInstance = null;
        GraphNode node = null;
        String workflowInstanceId = item.getProcessId();
        String nodeId = item.getVariable("nodeId");
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(item.getDocument());){
            if (StringUtils.isNotBlank((CharSequence)workflowInstanceId)) {
                NodeAccessRunner nodeAccessRunner = new NodeAccessRunner(wrapper.getSession(), workflowInstanceId, nodeId);
                try {
                    nodeAccessRunner.runUnrestricted();
                }
                catch (DocumentNotFoundException e) {
                    log.warn("Failed to get workflow instance: {}", (Object)workflowInstanceId);
                    log.debug((Object)e, (Throwable)e);
                }
                workflowInstance = nodeAccessRunner.getWorkflowInstance();
                node = nodeAccessRunner.getNode();
            }
            jg.writeStringField("id", item.getDocument().getId());
            jg.writeStringField("name", item.getName());
            jg.writeStringField("workflowInstanceId", workflowInstanceId);
            if (workflowInstance != null) {
                jg.writeStringField("workflowModelName", workflowInstance.getModelName());
                this.writeWorkflowInitiator(jg, workflowInstance.getInitiator());
                jg.writeStringField("workflowTitle", workflowInstance.getTitle());
                jg.writeStringField("workflowLifeCycleState", workflowInstance.getDocument().getCurrentLifeCycleState());
                jg.writeStringField("graphResource", DocumentRouteWriter.getGraphResourceURL(workflowInstance.getDocumentRoute(wrapper.getSession()), this.ctx));
            }
            jg.writeStringField("state", item.getDocument().getCurrentLifeCycleState());
            jg.writeStringField("directive", item.getDirective());
            jg.writeStringField("created", DateParser.formatW3CDateTime((Date)item.getCreated()));
            jg.writeStringField("dueDate", DateParser.formatW3CDateTime((Date)item.getDueDate()));
            jg.writeStringField("nodeName", item.getVariable("nodeId"));
            jg.writeArrayFieldStart("targetDocumentIds");
            boolean isFetchTargetDocumentIds = this.ctx.getFetched(ENTITY_TYPE).contains("targetDocumentIds");
            for (Object docId : item.getTargetDocumentsIds()) {
                IdRef idRef = new IdRef((String)docId);
                if (!wrapper.getSession().exists((DocumentRef)idRef)) continue;
                if (isFetchTargetDocumentIds) {
                    this.writeEntity(wrapper.getSession().getDocument((DocumentRef)idRef), jg);
                    continue;
                }
                jg.writeStartObject();
                jg.writeStringField("id", (String)docId);
                jg.writeEndObject();
            }
            jg.writeEndArray();
            boolean isFetchActors = this.ctx.getFetched(ENTITY_TYPE).contains(FETCH_ACTORS);
            jg.writeArrayFieldStart(FETCH_ACTORS);
            this.writeActors(item.getActors(), isFetchActors, jg);
            jg.writeEndArray();
            jg.writeArrayFieldStart("delegatedActors");
            this.writeActors(item.getDelegatedActors(), isFetchActors, jg);
            jg.writeEndArray();
            jg.writeArrayFieldStart("comments");
            for (TaskComment comment : item.getComments()) {
                jg.writeStartObject();
                jg.writeStringField("author", comment.getAuthor());
                jg.writeStringField("text", comment.getText());
                jg.writeStringField("date", DateParser.formatW3CDateTime((Date)comment.getCreationDate().getTime()));
                jg.writeEndObject();
            }
            jg.writeEndArray();
            jg.writeFieldName("variables");
            jg.writeStartObject();
            if (node != null) {
                TaskWriter.writeTaskVariables(node, jg, this.registry, this.ctx, this.schemaManager);
            }
            if (workflowInstance != null) {
                TaskWriter.writeWorkflowVariables(workflowInstance, node, jg, this.registry, this.ctx, this.schemaManager);
            }
            jg.writeEndObject();
            if (node != null) {
                jg.writeFieldName("taskInfo");
                jg.writeStartObject();
                jg.writeBooleanField("allowTaskReassignment", node.allowTaskReassignment());
                ActionManager actionManager = (ActionManager)Framework.getService(ActionManager.class);
                jg.writeArrayFieldStart("taskActions");
                for (GraphNode.Button button : node.getTaskButtons()) {
                    if (!StringUtils.isBlank((CharSequence)button.getFilter()) && !actionManager.checkFilter(button.getFilter(), TaskWriter.createActionContext(wrapper.getSession(), node))) continue;
                    jg.writeStartObject();
                    jg.writeStringField("name", button.getName());
                    jg.writeStringField("url", this.ctx.getBaseUrl() + "api/v1/task/" + item.getDocument().getId() + "/" + button.getName());
                    jg.writeStringField("label", button.getLabel());
                    jg.writeBooleanField("validate", button.getValidate().booleanValue());
                    jg.writeEndObject();
                }
                jg.writeEndArray();
                jg.writeFieldName("layoutResource");
                jg.writeStartObject();
                jg.writeStringField("name", node.getTaskLayout());
                jg.writeStringField("url", this.ctx.getBaseUrl() + "site/layout-manager/layouts/?layoutName=" + node.getTaskLayout());
                jg.writeEndObject();
                jg.writeArrayFieldStart("schemas");
                for (String schema : node.getDocument().getSchemas()) {
                    jg.writeStartObject();
                    jg.writeStringField("name", schema);
                    jg.writeStringField("url", this.ctx.getBaseUrl() + "api/v1/config/schemas/" + schema);
                    jg.writeEndObject();
                }
                jg.writeEndArray();
                jg.writeEndObject();
            }
        }
    }

    protected void writeActors(List<String> actors, boolean isFetchActors, JsonGenerator jg) throws IOException {
        for (String actorId : actors) {
            Object actor;
            if (isFetchActors && (actor = this.fetchActor(actorId)) != null) {
                this.writeEntity(actor, jg);
                continue;
            }
            jg.writeStartObject();
            jg.writeStringField("id", actorId);
            jg.writeEndObject();
        }
    }

    protected Object fetchActor(String actorId) {
        ObjectResolver resolver = ((ObjectResolverService)Framework.getService(ObjectResolverService.class)).getResolver("userManagerResolver", new HashMap());
        return resolver.fetch((Object)actorId);
    }

    protected void writeWorkflowInitiator(JsonGenerator jg, String workflowInitiator) throws IOException {
        Object principal;
        if (this.ctx.getFetched(ENTITY_TYPE).contains(FETCH_WORKFLOW_INITATIOR) && (principal = this.fetchActor(workflowInitiator)) != null) {
            this.writeEntityField(FETCH_WORKFLOW_INITATIOR, principal, jg);
            return;
        }
        jg.writeStringField(FETCH_WORKFLOW_INITATIOR, workflowInitiator);
    }

    @Deprecated
    protected static ActionContext createActionContext(CoreSession session) {
        return TaskWriter.createActionContext(session, null);
    }

    protected static ActionContext createActionContext(CoreSession session, GraphNode node) {
        ELActionContext actionContext = new ELActionContext();
        actionContext.setDocumentManager(session);
        actionContext.setCurrentPrincipal(session.getPrincipal());
        if (node != null) {
            HashMap<String, Serializable> workflowContextualInfo = new HashMap<String, Serializable>();
            workflowContextualInfo.putAll(node.getWorkflowContextualInfo(session, true));
            actionContext.putAllLocalVariables(workflowContextualInfo);
        }
        return actionContext;
    }

    public static void writeTaskVariables(GraphNode node, JsonGenerator jg, MarshallerRegistry registry, RenderingContext ctx, SchemaManager schemaManager) throws IOException {
        CompositeType type;
        if (node == null || node.getDocument() == null) {
            return;
        }
        String facet = (String)((Object)node.getDocument().getPropertyValue("rnode:variablesFacet"));
        if (StringUtils.isNotBlank((CharSequence)facet) && (type = schemaManager.getFacet(facet)) != null) {
            boolean hasFacet = node.getDocument().hasFacet(facet);
            Writer propertyWriter = registry.getWriter(ctx, Property.class, MediaType.APPLICATION_JSON_TYPE);
            try (Closeable resource = ctx.wrap().with("document", (Object)node.getDocument()).open();){
                for (Field f : type.getFields()) {
                    String name = f.getName().getLocalName();
                    Property property = hasFacet ? node.getDocument().getProperty(name) : null;
                    OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
                    jg.writeFieldName(name);
                    propertyWriter.write((Object)property, Property.class, Property.class, MediaType.APPLICATION_JSON_TYPE, (OutputStream)out);
                }
            }
        }
    }

    public static void writeWorkflowVariables(DocumentRoute route, GraphNode node, JsonGenerator jg, MarshallerRegistry registry, RenderingContext ctx, SchemaManager schemaManager) throws IOException {
        CompositeType type;
        String facet = (String)((Object)route.getDocument().getPropertyValue("docri:variablesFacet"));
        if (StringUtils.isNotBlank((CharSequence)facet) && (type = schemaManager.getFacet(facet)) != null) {
            String transientSchemaName = "var_global_" + node.getId();
            Schema transientSchema = schemaManager.getSchema(transientSchemaName);
            if (transientSchema == null) {
                return;
            }
            boolean hasFacet = route.getDocument().hasFacet(facet);
            Writer propertyWriter = registry.getWriter(ctx, Property.class, MediaType.APPLICATION_JSON_TYPE);
            try (Closeable resource = ctx.wrap().with("document", (Object)route.getDocument()).open();){
                for (Field f : type.getFields()) {
                    String name = f.getName().getLocalName();
                    if (!transientSchema.hasField(name)) continue;
                    Property property = hasFacet ? route.getDocument().getProperty(name) : null;
                    OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
                    jg.writeFieldName(name);
                    propertyWriter.write((Object)property, Property.class, Property.class, MediaType.APPLICATION_JSON_TYPE, (OutputStream)out);
                }
            }
        }
    }
}

