/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEscalationService;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.runtime.api.Framework;

public class DocumentRoutingEscalationListener
implements EventListener {
    public static final String EXECUTE_ESCALATION_RULE_EVENT = "executeEscalationRules";
    private static final Log log = LogFactory.getLog(DocumentRoutingEscalationListener.class);

    public void handleEvent(Event event) {
        if (!EXECUTE_ESCALATION_RULE_EVENT.equals(event.getName())) {
            return;
        }
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        for (String repositoryName : repositoryManager.getRepositoryNames()) {
            this.triggerEsclationRulesExecution(repositoryName);
        }
    }

    protected void triggerEsclationRulesExecution(String repositoryName) {
        log.error((Object)("Entering triggerEsclationRulesExecution for repo " + repositoryName));
        new UnrestrictedSessionRunner(repositoryName){

            public void run() {
                DocumentRoutingEscalationService escalationService = (DocumentRoutingEscalationService)Framework.getService(DocumentRoutingEscalationService.class);
                List<String> nodeIds = escalationService.queryForSuspendedNodesWithEscalation(this.session);
                log.error((Object)("SuspendedNodesWithEscalation size = " + nodeIds.size()));
                for (String id : nodeIds) {
                    DocumentModel nodeDoc = this.session.getDocument((DocumentRef)new IdRef(id));
                    GraphNode node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
                    List<GraphNode.EscalationRule> rules = escalationService.computeEscalationRulesToExecute(node);
                    log.error((Object)String.format("Rules for node %s = %d", id, rules.size()));
                    for (GraphNode.EscalationRule rule : rules) {
                        escalationService.scheduleExecution(rule, this.session);
                    }
                }
            }
        }.runUnrestricted();
    }
}

