/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.service.extension.ExportedZipImporter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;

public class RouteModelsZipImporter
extends ExportedZipImporter {
    private static final long serialVersionUID = 1L;
    public static final String WORKFLOW_KEY_VALUE_STORE = "workflowModels";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel createOrUpdate(FileImporterContext context) throws IOException {
        try (CloseableFile source = context.getBlob().getCloseableFile();){
            ZipFile zip = RouteModelsZipImporter.getArchiveFileIfValid((File)source.getFile());
            if (zip == null) {
                DocumentModel documentModel = null;
                return documentModel;
            }
            zip.close();
            KeyValueStore workflowKV = ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore(WORKFLOW_KEY_VALUE_STORE);
            String parentPath = context.getParentPath();
            CoreSession session = context.getSession();
            ExportedDocument rootDoc = this.getRootExportedDocument(source.getFile());
            if (!"DocumentRoute".equals(rootDoc.getType())) {
                DocumentModel documentModel = null;
                return documentModel;
            }
            Path rootPath = rootDoc.getPath();
            String rootName = rootPath.lastSegment();
            PathRef rootRef = new PathRef(parentPath, rootName);
            String rootDigest = this.getMD5Digest(source.getFile());
            String kvDigestKey = "digest-" + rootName;
            ACP currentRouteModelACP = null;
            if (session.exists((DocumentRef)rootRef)) {
                DocumentModel target = session.getDocument((DocumentRef)rootRef);
                if (rootDigest.equals(workflowKV.getString(kvDigestKey))) {
                    DocumentModel documentModel = target;
                    return documentModel;
                }
                currentRouteModelACP = target.getACP();
                session.removeDocument((DocumentRef)rootRef);
            }
            DocumentModelWriter writer = new DocumentModelWriter(session, parentPath, 10);
            NuxeoArchiveReader reader = new NuxeoArchiveReader(source.getFile());
            try {
                DocumentPipeImpl pipe = new DocumentPipeImpl(10);
                pipe.setReader((DocumentReader)reader);
                pipe.setWriter((DocumentWriter)writer);
                pipe.run();
            }
            finally {
                reader.close();
                writer.close();
            }
            workflowKV.put(kvDigestKey, rootDigest);
            DocumentModel newRouteModel = session.getDocument((DocumentRef)rootRef);
            if (currentRouteModelACP != null && context.isOverwrite()) {
                newRouteModel.setACP(currentRouteModelACP, true);
                newRouteModel = session.saveDocument(newRouteModel);
            }
            DocumentModel documentModel = newRouteModel;
            return documentModel;
        }
    }

    protected ExportedDocument getRootExportedDocument(File file) throws IOException {
        NuxeoArchiveReader reader = new NuxeoArchiveReader(file);
        ExportedDocument root = reader.read();
        reader.close();
        return root;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getMD5Digest(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            String string = DigestUtils.md5Hex((InputStream)in);
            return string;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }
}

