/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptorComparator;

public class EventListenerList {
    protected final List<EventListenerDescriptor> inlineListenersDescriptors = new ArrayList<EventListenerDescriptor>();
    protected final List<EventListenerDescriptor> syncPostCommitListenersDescriptors = new ArrayList<EventListenerDescriptor>();
    protected final List<EventListenerDescriptor> asyncPostCommitListenersDescriptors = new ArrayList<EventListenerDescriptor>();
    protected volatile List<EventListenerDescriptor> enabledInlineListenersDescriptors = null;
    protected volatile List<EventListenerDescriptor> enabledSyncPostCommitListenersDescriptors = null;
    protected volatile List<EventListenerDescriptor> enabledAsyncPostCommitListenersDescriptors = null;
    protected final Map<String, EventListenerDescriptor> descriptors = new HashMap<String, EventListenerDescriptor>();

    protected synchronized void flushCache() {
        this.enabledAsyncPostCommitListenersDescriptors = null;
        this.enabledInlineListenersDescriptors = null;
        this.enabledSyncPostCommitListenersDescriptors = null;
    }

    public void add(EventListenerDescriptor descriptor) {
        this.flushCache();
        if (this.descriptors.containsKey(descriptor.getName())) {
            descriptor = this.mergeDescriptor(descriptor);
        }
        descriptor.initListener();
        if (descriptor.isPostCommit) {
            if (descriptor.getIsAsync()) {
                this.asyncPostCommitListenersDescriptors.add(descriptor);
                Collections.sort(this.asyncPostCommitListenersDescriptors, new EventListenerDescriptorComparator());
            } else {
                this.syncPostCommitListenersDescriptors.add(descriptor);
                Collections.sort(this.syncPostCommitListenersDescriptors, new EventListenerDescriptorComparator());
            }
        } else {
            this.inlineListenersDescriptors.add(descriptor);
            Collections.sort(this.inlineListenersDescriptors, new EventListenerDescriptorComparator());
        }
        this.descriptors.put(descriptor.getName(), descriptor);
    }

    protected EventListenerDescriptor mergeDescriptor(EventListenerDescriptor descriptor) {
        EventListenerDescriptor existingDesc = this.getDescriptor(descriptor.getName());
        this.removeDescriptor(existingDesc);
        existingDesc.merge(descriptor);
        return existingDesc;
    }

    public void removeDescriptor(EventListenerDescriptor descriptor) {
        this.flushCache();
        if (this.descriptors.containsKey(descriptor.getName())) {
            if (descriptor.isPostCommit) {
                if (descriptor.getIsAsync()) {
                    this.asyncPostCommitListenersDescriptors.remove(descriptor);
                } else {
                    this.syncPostCommitListenersDescriptors.remove(descriptor);
                }
            } else {
                this.inlineListenersDescriptors.remove(descriptor);
            }
            this.descriptors.remove(descriptor.getName());
        }
    }

    public EventListenerDescriptor getDescriptor(String listenerName) {
        return this.descriptors.get(listenerName);
    }

    public List<EventListener> getInLineListeners() {
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        for (EventListenerDescriptor desc : this.getEnabledInlineListenersDescriptors()) {
            listeners.add(desc.asEventListener());
        }
        return listeners;
    }

    public List<PostCommitEventListener> getSyncPostCommitListeners() {
        ArrayList<PostCommitEventListener> listeners = new ArrayList<PostCommitEventListener>();
        for (EventListenerDescriptor desc : this.getEnabledSyncPostCommitListenersDescriptors()) {
            listeners.add(desc.asPostCommitListener());
        }
        return listeners;
    }

    public List<PostCommitEventListener> getAsyncPostCommitListeners() {
        ArrayList<PostCommitEventListener> listeners = new ArrayList<PostCommitEventListener>();
        for (EventListenerDescriptor desc : this.getEnabledAsyncPostCommitListenersDescriptors()) {
            listeners.add(desc.asPostCommitListener());
        }
        return listeners;
    }

    public List<EventListenerDescriptor> getInlineListenersDescriptors() {
        return this.inlineListenersDescriptors;
    }

    public List<EventListenerDescriptor> getSyncPostCommitListenersDescriptors() {
        return this.syncPostCommitListenersDescriptors;
    }

    public List<EventListenerDescriptor> getAsyncPostCommitListenersDescriptors() {
        return this.asyncPostCommitListenersDescriptors;
    }

    public synchronized void recomputeEnabledListeners() {
        this.enabledAsyncPostCommitListenersDescriptors = new ArrayList<EventListenerDescriptor>();
        for (EventListenerDescriptor desc : this.asyncPostCommitListenersDescriptors) {
            if (!desc.isEnabled) continue;
            this.enabledAsyncPostCommitListenersDescriptors.add(desc);
        }
        this.enabledSyncPostCommitListenersDescriptors = new ArrayList<EventListenerDescriptor>();
        for (EventListenerDescriptor desc : this.syncPostCommitListenersDescriptors) {
            if (!desc.isEnabled) continue;
            this.enabledSyncPostCommitListenersDescriptors.add(desc);
        }
        this.enabledInlineListenersDescriptors = new ArrayList<EventListenerDescriptor>();
        for (EventListenerDescriptor desc : this.inlineListenersDescriptors) {
            if (!desc.isEnabled) continue;
            this.enabledInlineListenersDescriptors.add(desc);
        }
    }

    public List<EventListenerDescriptor> getEnabledInlineListenersDescriptors() {
        if (this.enabledInlineListenersDescriptors == null) {
            this.recomputeEnabledListeners();
        }
        return new ArrayList<EventListenerDescriptor>(this.enabledInlineListenersDescriptors);
    }

    public List<EventListenerDescriptor> getEnabledSyncPostCommitListenersDescriptors() {
        if (this.enabledSyncPostCommitListenersDescriptors == null) {
            this.recomputeEnabledListeners();
        }
        return new ArrayList<EventListenerDescriptor>(this.enabledSyncPostCommitListenersDescriptors);
    }

    public List<EventListenerDescriptor> getEnabledAsyncPostCommitListenersDescriptors() {
        if (this.enabledAsyncPostCommitListenersDescriptors == null) {
            this.recomputeEnabledListeners();
        }
        return new ArrayList<EventListenerDescriptor>(this.enabledAsyncPostCommitListenersDescriptors);
    }

    public List<String> getListenerNames() {
        return new ArrayList<String>(this.descriptors.keySet());
    }

    public boolean hasListener(String name) {
        return this.descriptors.containsKey(name);
    }
}

