/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.adapter;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.routing.core.impl.ConditionalRunner;
import org.nuxeo.ecm.platform.routing.core.impl.DocumentRouteElementImpl;
import org.nuxeo.ecm.platform.routing.core.impl.DocumentRouteImpl;
import org.nuxeo.ecm.platform.routing.core.impl.DocumentRouteStepsContainerImpl;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNodeImpl;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRouteImpl;
import org.nuxeo.ecm.platform.routing.core.impl.ParallelRunner;
import org.nuxeo.ecm.platform.routing.core.impl.SerialRunner;
import org.nuxeo.ecm.platform.routing.core.impl.StepElementRunner;

public class DocumentRouteAdapterFactory
implements DocumentAdapterFactory {
    public Object getAdapter(DocumentModel doc, Class itf) {
        String type = doc.getType();
        if (doc.hasFacet("DocumentRoute")) {
            DocumentRoutingConstants.ExecutionTypeValues executionType = this.getExecutionType(doc, type);
            switch (executionType) {
                case serial: {
                    return new DocumentRouteImpl(doc, new SerialRunner());
                }
                case parallel: {
                    return new DocumentRouteImpl(doc, new ParallelRunner());
                }
                case graph: {
                    return new GraphRouteImpl(doc);
                }
            }
        } else {
            if (type.equals("RouteNode")) {
                return new GraphNodeImpl(doc);
            }
            if (doc.hasFacet("RouteStep")) {
                return new DocumentRouteElementImpl(doc, new StepElementRunner());
            }
            if (doc.hasFacet("ConditionalStepFolder")) {
                return new DocumentRouteStepsContainerImpl(doc, new ConditionalRunner());
            }
            if (doc.hasFacet("StepFolder")) {
                DocumentRoutingConstants.ExecutionTypeValues executionType = this.getExecutionType(doc, type);
                switch (executionType) {
                    case serial: {
                        return new DocumentRouteStepsContainerImpl(doc, new SerialRunner());
                    }
                    case parallel: {
                        return new DocumentRouteStepsContainerImpl(doc, new ParallelRunner());
                    }
                    case graph: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }
        return null;
    }

    protected DocumentRoutingConstants.ExecutionTypeValues getExecutionType(DocumentModel doc, String type) {
        DocumentRoutingConstants.ExecutionTypeValues executionType = DocumentRoutingConstants.ExecutionTypeValues.valueOf((String)((String)((Object)doc.getPropertyValue("stepf:execution"))));
        return executionType;
    }
}

