/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.routing.core.audit.RoutingAuditHelper;
import org.nuxeo.ecm.platform.routing.core.impl.AuditEventFirer;
import org.nuxeo.ecm.platform.routing.core.impl.DocumentRouteStepsContainerImpl;
import org.nuxeo.ecm.platform.routing.core.impl.ElementRunner;
import org.nuxeo.ecm.platform.routing.core.impl.EventFirer;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;

public class DocumentRouteImpl
extends DocumentRouteStepsContainerImpl
implements DocumentRoute {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentRouteImpl.class);

    public DocumentRouteImpl(DocumentModel doc, ElementRunner runner) {
        super(doc, runner);
    }

    @Override
    public boolean canUndoStep(CoreSession session) {
        return false;
    }

    protected void fireWorkflowCompletionEvent(CoreSession session) {
        EventFirer.fireEvent(session, this, null, DocumentRoutingConstants.Events.afterRouteFinish.name());
        HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
        long duration = RoutingAuditHelper.computeDurationSinceWfStarted(this.getDocument().getId());
        if (duration >= 0L) {
            eventProperties.put("timeSinceWfStarted", Long.valueOf(duration));
        }
        eventProperties.put("workflowInitiator", (Serializable)((Object)this.getInitiator()));
        if (this instanceof GraphRoute) {
            eventProperties.put("workflowVariables", (Serializable)((Object)((GraphRoute)((Object)this)).getVariables()));
        }
        eventProperties.put("modelId", (Serializable)((Object)this.getModelId()));
        eventProperties.put("modelName", (Serializable)((Object)this.getModelName()));
        EventFirer.fireEvent(session, this, eventProperties, DocumentRoutingConstants.Events.afterWorkflowFinish.name());
    }

    public String getInitiator() {
        return (String)((Object)this.document.getPropertyValue("initiator"));
    }

    public String getModelId() {
        return (String)((Object)this.document.getPropertyValue("docri:modelId"));
    }

    public String getModelName() {
        int firstDot = this.getName().indexOf(".");
        return firstDot > 0 ? this.getName().substring(0, firstDot) : this.getName();
    }

    @Override
    public void setDone(CoreSession session) {
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toDone, session, false);
        this.fireWorkflowCompletionEvent(session);
        for (String attachDocumentID : this.getAttachedDocuments()) {
            try {
                DocumentModel doc = session.getDocument((DocumentRef)new IdRef(attachDocumentID));
                AuditEventFirer.fireEvent(session, this, null, "auditLogRoute", doc);
            }
            catch (DocumentNotFoundException e) {
                log.error((Object)String.format("Unable to fetch document with id '%s': %s", attachDocumentID, e.getMessage()));
                log.debug((Object)e, (Throwable)e);
            }
        }
    }
}

