/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.io;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.core.io.NodeAccessRunner;
import org.nuxeo.ecm.platform.routing.core.io.TaskCompletionRequest;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class TaskCompletionRequestJsonReader
extends EntityJsonReader<TaskCompletionRequest> {
    public static final String ENTITY_TYPE = "task";
    private static final String USE_LEGACY_CONF_KEY = "nuxeo.document.routing.json.format.legacy";
    private Boolean useLegacy = null;
    @Inject
    SchemaManager schemaManager;

    public TaskCompletionRequestJsonReader() {
        super(ENTITY_TYPE);
        String prop = Framework.getProperty((String)USE_LEGACY_CONF_KEY);
        this.useLegacy = prop != null && Boolean.parseBoolean(prop) ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
        return this.useLegacy == false && !this.ctx.getBooleanParameter(USE_LEGACY_CONF_KEY) && super.accept(clazz, genericType, mediatype);
    }

    public TaskCompletionRequest readEntity(JsonNode jn) throws IOException {
        String comment = this.getStringField(jn, "comment");
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        try (RenderingContext.SessionWrapper closeable = this.ctx.getSession(null);){
            CoreSession session = closeable.getSession();
            String taskId = this.getStringField(jn, "id");
            DocumentModel taskDoc = session.getDocument((DocumentRef)new IdRef(taskId));
            Task task = (Task)taskDoc.getAdapter(Task.class);
            String routeId = task.getVariable("routeInstanceDocId");
            String nodeId = task.getVariable("nodeId");
            NodeAccessRunner nar = new NodeAccessRunner(session, routeId, nodeId);
            nar.runUnrestricted();
            GraphRoute graphRoute = nar.getWorkflowInstance();
            GraphNode node = nar.getNode();
            JsonNode variablesNode = jn.get("variables");
            if (variablesNode != null) {
                String workflowSchemaFacet = (String)((Object)graphRoute.getDocument().getPropertyValue("docri:variablesFacet"));
                CompositeType type = this.schemaManager.getFacet(workflowSchemaFacet);
                variables.putAll(this.getVariables(variablesNode, (Schema)type.getSchemas().stream().findFirst().get()));
                String nodeSchemaFacet = (String)((Object)node.getDocument().getPropertyValue("rnode:variablesFacet"));
                type = this.schemaManager.getFacet(nodeSchemaFacet);
                variables.putAll(this.getVariables(variablesNode, (Schema)type.getSchemas().stream().findFirst().get()));
            }
        }
        return new TaskCompletionRequest(comment, variables, false);
    }

    private Map<String, Serializable> getVariables(JsonNode variables, Schema schema) throws IOException {
        HashMap<String, Serializable> variable = new HashMap<String, Serializable>();
        String schemaName = schema.getNamespace() != null && schema.getNamespace().hasPrefix() ? schema.getNamespace().prefix : schema.getName();
        ParameterizedType genericType = TypeUtils.parameterize(List.class, (Type[])new Type[]{Property.class});
        try (Closeable resource = this.ctx.wrap().with("DEFAULT_SCHEMA_NAME", (Object)schema.getName()).open();){
            List properties = (List)this.readEntity(List.class, genericType, variables);
            for (Property property : properties) {
                variable.put(property.getName().substring(schemaName.length() + 1), property.getValue());
            }
        }
        return variable;
    }
}

