/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.slo;

import org.joda.time.DateTime;
import org.nuxeo.ecm.platform.auth.saml.AbstractSAMLProfile;
import org.nuxeo.ecm.platform.auth.saml.SAMLCredential;
import org.nuxeo.ecm.platform.auth.saml.slo.SLOProfile;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.validation.ValidationException;

public class SLOProfileImpl
extends AbstractSAMLProfile
implements SLOProfile {
    public SLOProfileImpl(SingleLogoutService slo) {
        super((Endpoint)slo);
    }

    @Override
    public String getProfileIdentifier() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:SSO:logout";
    }

    @Override
    public LogoutRequest buildLogoutRequest(SAMLMessageContext context, SAMLCredential credential) throws SAMLException {
        LogoutRequest request = (LogoutRequest)this.build(LogoutRequest.DEFAULT_ELEMENT_NAME);
        request.setID(this.newUUID());
        request.setVersion(SAMLVersion.VERSION_20);
        request.setIssueInstant(new DateTime());
        request.setDestination(this.getEndpoint().getLocation());
        if (credential.getSessionIndexes() == null || credential.getSessionIndexes().isEmpty()) {
            throw new SAMLException("No session indexes found");
        }
        for (String sessionIndex : credential.getSessionIndexes()) {
            SessionIndex index = (SessionIndex)this.build(SessionIndex.DEFAULT_ELEMENT_NAME);
            index.setSessionIndex(sessionIndex);
            request.getSessionIndexes().add(index);
        }
        request.setNameID(credential.getNameID());
        return request;
    }

    @Override
    public boolean processLogoutRequest(SAMLMessageContext context, SAMLCredential credential) throws SAMLException {
        NameID nameID;
        SAMLObject message = context.getInboundSAMLMessage();
        if (message == null || !(message instanceof LogoutRequest)) {
            throw new SAMLException("Message is not of a LogoutRequest object type");
        }
        LogoutRequest request = (LogoutRequest)message;
        if (request.getSignature() != null) {
            log.debug((Object)"Verifying message signature");
            try {
                this.validateSignature(request.getSignature(), context.getPeerEntityId());
            }
            catch (ValidationException e) {
                log.error((Object)"Error validating signature", (Throwable)e);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            context.setInboundSAMLMessageAuthenticated(true);
        }
        if (request.getIssuer() != null) {
            log.debug((Object)"Verifying issuer of the message");
            Issuer issuer = request.getIssuer();
            this.validateIssuer(issuer, context);
        }
        if (this.getDecrypter() != null && request.getEncryptedID() != null) {
            try {
                nameID = (NameID)this.getDecrypter().decrypt(request.getEncryptedID());
            }
            catch (DecryptionException e) {
                throw new SAMLException("Failed to decrypt NameID", (Exception)((Object)e));
            }
        } else {
            nameID = request.getNameID();
        }
        if (nameID == null) {
            throw new SAMLException("The requested NameID is invalid");
        }
        if (request.getSessionIndexes() == null || request.getSessionIndexes().isEmpty()) {
            return true;
        }
        for (SessionIndex sessionIndex : request.getSessionIndexes()) {
            if (!credential.getSessionIndexes().contains(sessionIndex.getSessionIndex())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processLogoutResponse(SAMLMessageContext context) throws SAMLException {
        String statusCode;
        SAMLObject message = context.getInboundSAMLMessage();
        if (!(message instanceof LogoutResponse)) {
            throw new SAMLException("Message is not of a LogoutResponse object type");
        }
        LogoutResponse response = (LogoutResponse)message;
        if (response.getSignature() != null) {
            log.debug((Object)"Verifying message signature");
            try {
                this.validateSignature(response.getSignature(), context.getPeerEntityId());
            }
            catch (ValidationException e) {
                log.error((Object)"Error validating signature", (Throwable)e);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            context.setInboundSAMLMessageAuthenticated(true);
        }
        if (response.getIssuer() != null) {
            log.debug((Object)"Verifying issuer of the message");
            Issuer issuer = response.getIssuer();
            this.validateIssuer(issuer, context);
        }
        if (!(statusCode = response.getStatus().getStatusCode().getValue()).equals("urn:oasis:names:tc:SAML:2.0:status:Success") && !statusCode.equals("urn:oasis:names:tc:SAML:2.0:status:PartialLogout")) {
            log.warn((Object)("Invalid status code " + statusCode + ": " + response.getStatus().getStatusMessage()));
        }
    }
}

