/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf.rules;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.waf.actions.Action;
import org.owasp.esapi.waf.actions.DoNothingAction;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import org.owasp.esapi.waf.rules.Rule;

public class BeanShellRule
extends Rule {
    private Interpreter i = new Interpreter();
    private String script;
    private Pattern path;

    public BeanShellRule(String fileLocation, String id, Pattern path) throws IOException, EvalError {
        this.i.set("logger", (Object)logger);
        this.script = this.getFileContents(ESAPI.securityConfiguration().getResourceFile(fileLocation));
        this.id = id;
        this.path = path;
    }

    @Override
    public Action check(HttpServletRequest request, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        if (this.path != null && !this.path.matcher(request.getRequestURI()).matches()) {
            return new DoNothingAction();
        }
        try {
            Action a = null;
            this.i.set("action", a);
            this.i.set("request", (Object)request);
            if (response != null) {
                this.i.set("response", (Object)response);
            } else {
                this.i.set("response", (Object)httpResponse);
            }
            this.i.set("session", (Object)request.getSession());
            this.i.eval(this.script);
            a = (Action)this.i.get("action");
            if (a != null) {
                return a;
            }
        }
        catch (EvalError e) {
            this.log(request, "Error running custom beanshell rule (" + this.id + ") - " + e.getMessage());
        }
        return new DoNothingAction();
    }

    private String getFileContents(File f) throws IOException {
        String line;
        FileReader fr = new FileReader(f);
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(fr);
        while ((line = br.readLine()) != null) {
            sb.append(line + System.getProperty("line.separator"));
        }
        return sb.toString();
    }
}

