/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import org.owasp.esapi.codecs.PushbackString;

public abstract class Codec {
    private static final String[] hex = new String[256];

    public String encode(char[] immune, String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            sb.append(this.encodeCharacter(immune, Character.valueOf(c)));
        }
        return sb.toString();
    }

    public String encodeCharacter(char[] immune, Character c) {
        return "" + c;
    }

    public String decode(String input) {
        StringBuilder sb = new StringBuilder();
        PushbackString pbs = new PushbackString(input);
        while (pbs.hasNext()) {
            Character c = this.decodeCharacter(pbs);
            if (c != null) {
                sb.append(c);
                continue;
            }
            sb.append(pbs.next());
        }
        return sb.toString();
    }

    public Character decodeCharacter(PushbackString input) {
        return input.next();
    }

    public static String getHexForNonAlphanumeric(char c) {
        if (c < '\u00ff') {
            return hex[c];
        }
        return Codec.toHex(c);
    }

    public static String toOctal(char c) {
        return Integer.toOctalString(c);
    }

    public static String toHex(char c) {
        return Integer.toHexString(c);
    }

    public static boolean containsCharacter(char c, char[] array) {
        for (char ch : array) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    static {
        for (char c = '\u0000'; c < '\u00ff'; c = (char)(c + '\u0001')) {
            Codec.hex[c] = c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' ? null : Codec.toHex(c).intern();
        }
    }
}

