/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.resource;

import java.io.InputStream;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.util.resource.ResourceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilteredResource
implements Resource {
    private final Logger log = LoggerFactory.getLogger(AbstractFilteredResource.class);
    private ResourceFilter resourceFilter;

    protected AbstractFilteredResource() {
    }

    protected AbstractFilteredResource(ResourceFilter filter) {
        this.resourceFilter = filter;
    }

    public ResourceFilter getResourceFilter() {
        return this.resourceFilter;
    }

    public void setResourceFilter(ResourceFilter filter) {
        this.resourceFilter = filter;
    }

    protected InputStream applyFilter(InputStream stream) throws ResourceException {
        ResourceFilter filter = this.getResourceFilter();
        if (filter != null) {
            this.log.debug("Apply filter '{}' to resource '{}'", filter.getClass(), (Object)this.getLocation());
            return this.getResourceFilter().applyFilter(stream);
        }
        return stream;
    }
}

