/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.user;

import java.util.Map;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.auth.saml.SAMLCredential;
import org.nuxeo.ecm.platform.auth.saml.user.UserResolver;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.usermapper.service.UserMapperService;

public class UserMapperBasedResolver
implements UserResolver {
    protected static final String USER_RESOLVER_MAPPING = "userResolverMapping";
    protected static final String USER_RESOLVER_CREATE_IF_NEEDED = "userResolverCreateIfNeeded";
    protected static final String USER_RESOLVER_UPDATE = "userResolverUpdate";
    protected static final String DEFAULT_USER_MAPPER_CONFIG = "saml";
    protected String mapperName = "saml";
    protected boolean createIfNeeded = true;
    protected boolean update = true;

    @Override
    public void init(Map<String, String> parameters) {
        if (parameters.containsKey(USER_RESOLVER_MAPPING)) {
            this.mapperName = parameters.get(USER_RESOLVER_MAPPING);
        }
        if (parameters.containsKey(USER_RESOLVER_CREATE_IF_NEEDED)) {
            this.createIfNeeded = Boolean.getBoolean(parameters.get(USER_RESOLVER_CREATE_IF_NEEDED));
        }
        if (parameters.containsKey(USER_RESOLVER_UPDATE)) {
            this.update = Boolean.getBoolean(parameters.get(USER_RESOLVER_UPDATE));
        }
    }

    @Override
    public String findOrCreateNuxeoUser(SAMLCredential userInfo) {
        NuxeoPrincipal principal = ((UserMapperService)Framework.getService(UserMapperService.class)).getOrCreateAndUpdateNuxeoPrincipal(this.mapperName, (Object)userInfo, this.createIfNeeded, this.update, null);
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }
}

