/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.nuxeo.automation.scripting.internals.DocumentScriptingWrapper;

public class ScriptObjectMirrors {
    private static final String JAVASCRIPT_MAP_CLASS_TYPE = "Object";
    private static final String JAVASCRIPT_DATE_CLASS_TYPE = "Date";
    private static final String JAVASCRIPT_GLOBAL_CLASS_TYPE = "global";
    private static final String JAVASCRIPT_FUNCTION_CLASS_TYPE = "Function";

    private ScriptObjectMirrors() {
    }

    public static Object unwrap(ScriptObjectMirror jso) {
        if (jso.isArray()) {
            return ScriptObjectMirrors.unwrapList(jso);
        }
        if (JAVASCRIPT_MAP_CLASS_TYPE.equals(jso.getClassName())) {
            return ScriptObjectMirrors.unwrapMap(jso);
        }
        if (JAVASCRIPT_DATE_CLASS_TYPE.equals(jso.getClassName())) {
            return ScriptObjectMirrors.unwrapDate(jso);
        }
        if (JAVASCRIPT_GLOBAL_CLASS_TYPE.equals(jso.getClassName())) {
            return null;
        }
        if (JAVASCRIPT_FUNCTION_CLASS_TYPE.equals(jso.getClassName())) {
            return null;
        }
        throw new UnsupportedOperationException(jso.getClassName() + " is not supported!");
    }

    public static List<Object> unwrapList(ScriptObjectMirror jso) {
        if (!jso.isArray()) {
            throw new IllegalArgumentException("JavaScript input is not an Array!");
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (Object o : jso.values()) {
            if (o instanceof ScriptObjectMirror) {
                l.add(ScriptObjectMirrors.unwrap((ScriptObjectMirror)o));
                continue;
            }
            l.add(o);
        }
        return l;
    }

    public static Map<String, Object> unwrapMap(ScriptObjectMirror jso) {
        if (!JAVASCRIPT_MAP_CLASS_TYPE.equals(jso.getClassName())) {
            throw new IllegalArgumentException("JavaScript input is not an Object!");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String k : jso.keySet()) {
            Object o = jso.get((Object)k);
            if (o instanceof ScriptObjectMirror) {
                result.put(k, ScriptObjectMirrors.unwrap((ScriptObjectMirror)o));
                continue;
            }
            result.put(k, DocumentScriptingWrapper.unwrap(o));
        }
        return result;
    }

    public static Calendar unwrapDate(ScriptObjectMirror jso) {
        if (!JAVASCRIPT_DATE_CLASS_TYPE.equals(jso.getClassName())) {
            throw new IllegalArgumentException("JavaScript input is not a Date!");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(((Double)jso.callMember("getTime", new Object[0])).longValue());
        return cal;
    }

    public static Object wrap(Map<String, Object> map) {
        return ScriptObjectMirror.wrap(map, null);
    }
}

