/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import java.util.Arrays;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.automation.OperationDocumentation;

@XObject(value="scriptedOperation")
public class ScriptingOperationDescriptor {
    @XNode(value="@id")
    protected String id;
    @XNode(value="@enabled")
    protected boolean enabled = true;
    @XNode(value="inputType")
    protected String inputType;
    @XNode(value="outputType")
    protected String outputType;
    @XNode(value="description")
    protected String description;
    @XNode(value="category")
    protected String category;
    @XNodeList(value="aliases/alias", type=String[].class, componentType=String.class)
    protected String[] aliases;
    @XNodeList(value="param", type=OperationDocumentation.Param[].class, componentType=OperationDocumentation.Param.class)
    protected OperationDocumentation.Param[] params = new OperationDocumentation.Param[0];
    @XNode(value="script")
    protected String source;
    protected String contributingComponent;

    public String[] getAliases() {
        return this.aliases;
    }

    public String getInputType() {
        return this.inputType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public OperationDocumentation.Param[] getParams() {
        return this.params;
    }

    public String getContributingComponent() {
        return this.contributingComponent;
    }

    public void setContributingComponent(String contributingComponent) {
        this.contributingComponent = contributingComponent;
    }

    public ScriptingOperationDescriptor clone() {
        ScriptingOperationDescriptor clone = new ScriptingOperationDescriptor();
        clone.id = this.id;
        clone.enabled = this.enabled;
        clone.inputType = this.inputType;
        clone.outputType = this.outputType;
        clone.description = this.description;
        clone.category = this.category;
        if (this.aliases != null) {
            clone.aliases = Arrays.copyOf(this.aliases, this.aliases.length);
        }
        if (this.params != null) {
            clone.params = Arrays.copyOf(this.params, this.params.length);
        }
        clone.source = this.source;
        clone.contributingComponent = this.contributingComponent;
        return clone;
    }

    public void merge(ScriptingOperationDescriptor other) {
        this.enabled = other.enabled;
        this.inputType = other.inputType;
        this.outputType = other.outputType;
        this.description = other.description;
        this.category = other.category;
        this.aliases = other.aliases;
        this.params = other.params;
        this.source = other.source;
        this.contributingComponent = other.contributingComponent;
    }
}

