/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.nuxeo.automation.scripting.internals.AutomationScriptingServiceImpl;
import org.nuxeo.automation.scripting.internals.ScriptingOperationDescriptor;
import org.nuxeo.automation.scripting.internals.ScriptingOperationImpl;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;

public class ScriptingOperationTypeImpl
implements OperationType {
    protected AutomationScriptingServiceImpl scripting;
    protected AutomationService automation;
    protected ScriptingOperationDescriptor desc;
    protected InvokableMethod method;

    public ScriptingOperationTypeImpl(AutomationScriptingServiceImpl scripting, AutomationService automation, ScriptingOperationDescriptor desc) {
        this.scripting = scripting;
        this.automation = automation;
        this.desc = desc;
        this.method = ScriptingOperationTypeImpl.runMethod(this, desc.getInputType());
    }

    public String getContributingComponent() {
        return this.desc.getContributingComponent();
    }

    public OperationDocumentation getDocumentation() {
        OperationDocumentation doc = new OperationDocumentation(this.getId());
        doc.label = this.getId();
        doc.category = this.desc.getCategory();
        doc.description = this.desc.getDescription();
        doc.params = this.desc.getParams();
        doc.signature = new String[]{this.desc.getInputType(), this.desc.getOutputType()};
        doc.aliases = this.desc.getAliases();
        return doc;
    }

    public String getId() {
        return this.desc.getId();
    }

    public String[] getAliases() {
        return this.desc.getAliases();
    }

    public Object newInstance(OperationContext ctx, Map<String, Object> args) throws OperationException {
        HashMap<String, Object> params = new HashMap<String, Object>(args);
        this.scripting.paramsInjector.inject(params, ctx, this.desc);
        return new ScriptingOperationImpl(this.desc.source, ctx, params);
    }

    public Class<?> getType() {
        return ScriptingOperationImpl.class;
    }

    public String getInputType() {
        return this.desc.getInputType();
    }

    public AutomationService getService() {
        return this.automation;
    }

    public InvokableMethod[] getMethodsMatchingInput(Class<?> in) {
        return new InvokableMethod[]{this.method};
    }

    public List<InvokableMethod> getMethods() {
        return Collections.singletonList(this.method);
    }

    protected static InvokableMethod runMethod(ScriptingOperationTypeImpl op, String inputType) {
        try {
            Method method = inputType == null ? ScriptingOperationImpl.class.getMethod("run", new Class[0]) : ScriptingOperationImpl.class.getMethod("run", Object.class);
            return new InvokableMethod((OperationType)op, method);
        }
        catch (ReflectiveOperationException cause) {
            throw new Error("Cannot reference run method of " + ScriptingOperationImpl.class);
        }
    }

    public boolean isEnabled() {
        return this.desc.isEnabled();
    }

    public ScriptingOperationTypeImpl clone() {
        return new ScriptingOperationTypeImpl(this.scripting, this.automation, this.desc.clone());
    }

    public void merge(OperationType other) {
        ScriptingOperationTypeImpl os = (ScriptingOperationTypeImpl)other;
        this.scripting = os.scripting;
        this.automation = os.automation;
        this.desc.merge(os.desc);
        this.method = os.method;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).append(this.getType()).append((Object)this.getInputType()).append((Object)this.desc.getOutputType()).append((Object)this.desc.category).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScriptingOperationTypeImpl)) {
            return false;
        }
        ScriptingOperationTypeImpl other = (ScriptingOperationTypeImpl)obj;
        return this.getId().equals(other.getId()) && this.getType().equals(other.getType()) && this.getInputType().equals(other.getInputType()) && this.desc.getOutputType().equals(other.desc.getOutputType()) && this.desc.category.equals(other.desc.category);
    }
}

