/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.semanticentities.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoCmisService;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepository;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;

public class CMISQLDocumentPageProvider
extends AbstractPageProvider<DocumentModel>
implements PageProvider<DocumentModel> {
    public static final Log log = LogFactory.getLog(CMISQLDocumentPageProvider.class);
    private static final long serialVersionUID = 1L;
    protected final CoreSession session;
    protected final String query;
    protected final String docIdColumnName;
    protected final String rootDocId;
    protected List<DocumentModel> currentPageDocumentModels;

    public CMISQLDocumentPageProvider(CoreSession session, String query, String docIdColumnName, String providerName) throws ClientException {
        this.session = session;
        this.rootDocId = session.getRootDocument().getId();
        this.query = query;
        this.docIdColumnName = docIdColumnName;
        this.pageSize = 10L;
        this.name = providerName;
    }

    public List<DocumentModel> getCurrentPage() {
        if (this.currentPageDocumentModels == null) {
            this.currentPageDocumentModels = new ArrayList<DocumentModel>();
            IterableQueryResult result = null;
            NuxeoRepository rep = new NuxeoRepository(this.session.getRepositoryName(), this.rootDocId);
            NuxeoCmisService cmisService = new NuxeoCmisService(rep, null, this.session);
            try {
                result = this.session.queryAndFetch(this.query, "CMISQL", new Object[]{cmisService});
                this.resultsCount = result.size();
                if (this.offset < this.resultsCount) {
                    result.skipTo(this.offset);
                }
                Iterator it = result.iterator();
                int pos = 0;
                while (it.hasNext() && (long)pos < this.pageSize) {
                    ++pos;
                    Map selectedAttributes = (Map)it.next();
                    IdRef docRef = new IdRef(((Serializable)selectedAttributes.get(this.docIdColumnName)).toString());
                    DocumentModel doc = this.session.getDocument((DocumentRef)docRef);
                    this.currentPageDocumentModels.add(doc);
                }
            }
            catch (Exception e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            finally {
                cmisService.close();
                if (result != null) {
                    result.close();
                }
            }
        }
        return this.currentPageDocumentModels;
    }

    public void refresh() {
        super.refresh();
        this.currentPageDocumentModels = null;
    }
}

