/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.semanticentities.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.semanticentities.service.ParameterizedRemoteEntitySource;
import org.nuxeo.runtime.model.RuntimeContext;

@XObject(value="remoteSource")
public class RemoteEntitySourceDescriptor {
    @XNode(value="@name")
    protected String name;
    @XNode(value="@uriPrefix")
    protected String uriPrefix;
    @XNode(value="@class")
    protected String className;
    @XNode(value="@enabled")
    protected boolean enabled = false;
    @XNode(value="typeMapping@default")
    protected String defaultType;
    protected ParameterizedRemoteEntitySource source;
    @XNodeMap(value="typeMapping/type", key="@name", type=HashMap.class, componentType=String.class)
    protected Map<String, String> mappedTypes = Collections.emptyMap();
    @XNodeMap(value="propertyMapping/field", key="@name", type=HashMap.class, componentType=String.class)
    protected Map<String, String> mappedProperties = Collections.emptyMap();

    public String getDefaultType() {
        return this.defaultType;
    }

    public Map<String, String> getMappedTypes() {
        return this.mappedTypes;
    }

    public Map<String, String> getMappedProperties() {
        return this.mappedProperties;
    }

    public String getName() {
        return this.name;
    }

    public String getUriPrefix() {
        return this.uriPrefix;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void initializeInContext(RuntimeContext context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.className != null) {
            this.source = (ParameterizedRemoteEntitySource)context.loadClass(this.className).newInstance();
            this.source.setDescriptor(this);
        } else if (this.enabled) {
            throw new InstantiationException(String.format("Remote source descriptor '%s'  with enabled=\"true\" must provide a class to instantiate", this.name));
        }
    }

    public ParameterizedRemoteEntitySource getEntitySource() {
        return this.source;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.uriPrefix == null ? 0 : this.uriPrefix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteEntitySourceDescriptor other = (RemoteEntitySourceDescriptor)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.uriPrefix == null ? other.uriPrefix != null : !this.uriPrefix.equals(other.uriPrefix));
    }
}

