/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.semanticentities.sources;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.platform.semanticentities.DereferencingException;
import org.nuxeo.ecm.platform.semanticentities.RemoteEntity;
import org.nuxeo.ecm.platform.semanticentities.service.ParameterizedRemoteEntitySource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DBpediaEntitySource
extends ParameterizedRemoteEntitySource {
    public static final String OWL_THING = "http://www.w3.org/2002/07/owl#Thing";
    public static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private static final Log log = LogFactory.getLog(DBpediaEntitySource.class);
    protected static final String SPARQL_URL_PATTERN = "%s?query=%s&format=%s";
    protected String SUGGESTION_URL_PATTERN = "http://lookup.dbpedia.org/api/search.asmx/KeywordSearch?QueryString=%s&QueryClass=%s&MaxHits=%d";
    protected String SPARQL_ENDPOINT = "http://dbpedia.org/sparql";
    protected String RESULT_NODE_XPATH = "//Result";
    protected Map<URI, Model> cachedModels = new WeakHashMap<URI, Model>();
    protected HttpClient httpClient;

    public DBpediaEntitySource() {
        this.initHttpClient();
    }

    protected void initHttpClient() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        BasicHttpParams params = new BasicHttpParams();
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
    }

    public boolean canSuggestRemoteEntity() {
        return true;
    }

    public Set<String> getAdmissibleTypes(URI remoteEntity) throws DereferencingException {
        Model rdfModel = this.fetchRDFDescription(remoteEntity);
        return this.extractMappedTypesFromModel(remoteEntity, rdfModel);
    }

    public void dereferenceInto(DocumentModel localEntity, URI remoteEntity, boolean override) throws DereferencingException {
        Model rdfModel = this.fetchRDFDescription(remoteEntity);
        Set<String> possibleTypes = this.extractMappedTypesFromModel(remoteEntity, rdfModel);
        if (!possibleTypes.contains(localEntity.getType())) {
            throw new DereferencingException(String.format("Remote entity '%s' can be mapped to types: ('%s') but not to '%s'", remoteEntity, StringUtils.join(possibleTypes, (String)"', '"), localEntity.getType()));
        }
        this.syncPropertiesFromModel(remoteEntity, rdfModel, localEntity, override);
    }

    protected Model fetchRDFDescription(URI remoteEntity) throws DereferencingException {
        Model rdfModel = this.cachedModels.get(remoteEntity);
        if (rdfModel != null) {
            return rdfModel;
        }
        InputStream bodyStream = null;
        try {
            StringBuilder constructPredicates = new StringBuilder();
            StringBuilder wherePredicates = new StringBuilder();
            constructPredicates.append(String.format("<%s> a ?t . ", remoteEntity));
            constructPredicates.append("\n");
            wherePredicates.append(String.format("<%s> a ?t . ", remoteEntity));
            wherePredicates.append("\n");
            int i = 0;
            for (String property : new TreeSet<String>(this.descriptor.getMappedProperties().values())) {
                constructPredicates.append(String.format("<%s> <%s> ?v%d . ", remoteEntity, property, i));
                constructPredicates.append("\n");
                wherePredicates.append(String.format("OPTIONAL { <%s> <%s> ?v%d } . ", remoteEntity, property, i));
                wherePredicates.append("\n");
                ++i;
            }
            StringBuilder sparqlQuery = new StringBuilder();
            sparqlQuery.append("CONSTRUCT { ");
            sparqlQuery.append((CharSequence)constructPredicates);
            sparqlQuery.append(" } WHERE { ");
            sparqlQuery.append((CharSequence)wherePredicates);
            sparqlQuery.append(" }");
            String encodedQuery = URLEncoder.encode(sparqlQuery.toString(), "UTF-8");
            String format = "application/rdf+xml";
            String encodedFormat = URLEncoder.encode(format, "UTF-8");
            URI sparqlURI = URI.create(String.format(SPARQL_URL_PATTERN, this.SPARQL_ENDPOINT, encodedQuery, encodedFormat));
            bodyStream = this.fetchResourceAsStream(sparqlURI, format);
            rdfModel = ModelFactory.createDefaultModel();
            RDFReader reader = rdfModel.getReader();
            reader.read(rdfModel, bodyStream, null);
            if (this.cachedModels.size() > 1000) {
                this.cachedModels.clear();
            }
            this.cachedModels.put(remoteEntity, rdfModel);
        }
        catch (MalformedURLException e) {
            throw new DereferencingException((Throwable)e);
        }
        catch (IOException e) {
            throw new DereferencingException((Throwable)e);
        }
        finally {
            if (bodyStream != null) {
                try {
                    bodyStream.close();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        return rdfModel;
    }

    protected Set<String> extractMappedTypesFromModel(URI remoteEntity, Model rdfModel) {
        Resource resource = rdfModel.getResource(remoteEntity.toString());
        com.hp.hpl.jena.rdf.model.Property type = rdfModel.getProperty(RDF_TYPE);
        TreeSet<String> typeURIs = new TreeSet<String>();
        TreeSet<String> mappedLocalTypes = new TreeSet<String>();
        NodeIterator it = rdfModel.listObjectsOfProperty(resource, type);
        while (it.hasNext()) {
            RDFNode node = it.nextNode();
            if (!node.isURIResource()) continue;
            typeURIs.add(((Resource)node.as(Resource.class)).getURI());
        }
        Set<Map.Entry<String, String>> typeMapping = this.descriptor.getMappedTypes().entrySet();
        for (Map.Entry<String, String> typeMapEntry : typeMapping) {
            if (!typeURIs.contains(typeMapEntry.getValue())) continue;
            mappedLocalTypes.add(typeMapEntry.getKey());
        }
        return mappedLocalTypes;
    }

    protected void syncPropertiesFromModel(URI remoteEntity, Model rdfModel, DocumentModel localEntity, boolean override) throws DereferencingException {
        HashSet<Map.Entry<String, String>> mapping = new HashSet<Map.Entry<String, String>>(this.descriptor.getMappedProperties().entrySet());
        Resource resource = rdfModel.getResource(remoteEntity.toString());
        ArrayList<String> samesas = new ArrayList<String>();
        ArrayList<String> sameasDisplayLabel = new ArrayList<String>();
        try {
            Property property;
            Property sameasProp = localEntity.getProperty("entity:sameas");
            if (sameasProp.getValue() != null) {
                samesas.addAll((Collection)sameasProp.getValue(List.class));
            }
            if ((property = localEntity.getProperty("entity:sameasDisplayLabel")).getValue() != null) {
                sameasDisplayLabel.addAll((Collection)property.getValue(List.class));
            }
            if (!samesas.contains(remoteEntity.toString())) {
                samesas.add(remoteEntity.toString());
                localEntity.setPropertyValue("entity:sameas", (Serializable)samesas);
                String titlePropUri = this.descriptor.getMappedProperties().get("dc:title");
                String label = localEntity.getTitle();
                String string = label = label != null ? label : "Missing label";
                if (titlePropUri != null) {
                    String labelFromRDF = (String)((Object)this.readDecodedLiteral(rdfModel, resource, titlePropUri, (Type)StringType.INSTANCE, "en"));
                    label = labelFromRDF != null ? labelFromRDF : label;
                }
                sameasDisplayLabel.add(label);
                localEntity.setPropertyValue("entity:sameasDisplayLabel", (Serializable)sameasDisplayLabel);
            }
        }
        catch (Exception e) {
            throw new DereferencingException((Throwable)e);
        }
        mapping.remove("entity:sameas");
        for (Map.Entry entry : mapping) {
            String localPropertyName = (String)entry.getKey();
            String remotePropertyUri = (String)entry.getValue();
            try {
                Property localProperty = localEntity.getProperty(localPropertyName);
                Type type = localProperty.getType();
                if (type.isListType()) {
                    ArrayList<String> newValues = new ArrayList<String>();
                    if (localProperty.getValue() != null) {
                        newValues.addAll((Collection)localProperty.getValue(List.class));
                    }
                    if (override) {
                        newValues.clear();
                    }
                    for (String value : this.readStringList(rdfModel, resource, remotePropertyUri)) {
                        if (newValues.contains(value)) continue;
                        newValues.add(value);
                    }
                    localEntity.setPropertyValue(localPropertyName, (Serializable)newValues);
                    continue;
                }
                if (localProperty.getValue() != null && !"".equals(localProperty.getValue()) && !override) continue;
                if (type.isComplexType() && "content".equals(type.getName())) {
                    Serializable linkedResource = (Serializable)this.readLinkedResource(rdfModel, resource, remotePropertyUri);
                    if (resource == null) continue;
                    localEntity.setPropertyValue(localPropertyName, linkedResource);
                    continue;
                }
                Serializable literal = this.readDecodedLiteral(rdfModel, resource, remotePropertyUri, type, "en");
                if (literal == null) continue;
                localEntity.setPropertyValue(localPropertyName, literal);
            }
            catch (PropertyException e) {
            }
            catch (ClientException e) {
                throw new DereferencingException((Throwable)e);
            }
        }
    }

    protected Serializable readDecodedLiteral(Model rdfModel, Resource resource, String remotePropertyUri, Type type, String requestedLang) {
        com.hp.hpl.jena.rdf.model.Property remoteProperty = rdfModel.getProperty(remotePropertyUri);
        NodeIterator it = rdfModel.listObjectsOfProperty(resource, remoteProperty);
        while (it.hasNext()) {
            Literal literal;
            String lang;
            RDFNode node = it.nextNode();
            if (!node.isLiteral() || (lang = (literal = (Literal)node.as(Literal.class)).getLanguage()) != null && !lang.equals("") && !lang.equals(requestedLang)) continue;
            Object decoded = (Serializable)type.decode(literal.getString());
            if (decoded instanceof String) {
                decoded = StringEscapeUtils.unescapeHtml((String)((String)decoded));
            }
            return decoded;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Blob readLinkedResource(Model rdfModel, Resource resource, String remotePropertyUri) {
        com.hp.hpl.jena.rdf.model.Property remoteProperty = rdfModel.getProperty(remotePropertyUri);
        NodeIterator it = rdfModel.listObjectsOfProperty(resource, remoteProperty);
        if (it.hasNext()) {
            String contentURI = ((Resource)it.nextNode().as(Resource.class)).getURI();
            InputStream is = null;
            try {
                is = this.fetchResourceAsStream(URI.create(contentURI), null);
                if (is == null) {
                    log.warn((Object)("failed to fetch resource: " + contentURI));
                    Blob blob = null;
                    return blob;
                }
                Blob blob = StreamingBlob.createFromStream((InputStream)is).persist();
                int lastSlashIndex = contentURI.lastIndexOf(47);
                if (lastSlashIndex != -1) {
                    blob.setFilename(contentURI.substring(lastSlashIndex + 1));
                }
                Blob blob2 = blob;
                return blob2;
            }
            catch (IOException e) {
                log.warn((Object)e.getMessage());
                Blob blob = null;
                return blob;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    protected List<String> readStringList(Model rdfModel, Resource resource, String remotePropertyUri) {
        com.hp.hpl.jena.rdf.model.Property remoteProperty = rdfModel.getProperty(remotePropertyUri);
        NodeIterator it = rdfModel.listObjectsOfProperty(resource, remoteProperty);
        ArrayList<String> collectedValues = new ArrayList<String>();
        while (it.hasNext()) {
            RDFNode node = it.nextNode();
            String value = null;
            if (node.isLiteral()) {
                value = ((Literal)node.as(Literal.class)).getString();
                value = StringEscapeUtils.unescapeHtml((String)value);
            } else {
                if (!node.isURIResource()) continue;
                value = ((Resource)node.as(Resource.class)).getURI();
            }
            if (value == null || collectedValues.contains(value)) continue;
            collectedValues.add(value);
        }
        return collectedValues;
    }

    public List<RemoteEntity> suggestRemoteEntity(String keywords, String type, int maxSuggestions) throws IOException {
        TreeSet<String> acceptedTypes = new TreeSet<String>();
        if (type != null) {
            acceptedTypes.add(this.descriptor.getMappedTypes().get(type));
        } else {
            acceptedTypes.addAll(this.descriptor.getMappedTypes().values());
        }
        InputStream bodyStream = this.fetchSuggestions(keywords, "Thing", maxSuggestions * 3);
        if (bodyStream == null) {
            throw new IOException(String.format("Unable to fetch suggestion response for '%s' with type '%s'", keywords, type));
        }
        ArrayList<RemoteEntity> suggestions = new ArrayList<RemoteEntity>();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(bodyStream);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList resultNodes = (NodeList)xpath.evaluate(this.RESULT_NODE_XPATH, document, XPathConstants.NODESET);
            for (int i = 0; i < resultNodes.getLength(); ++i) {
                Node uriNode;
                Node resultNode = resultNodes.item(i);
                String label = null;
                URI uri = null;
                boolean hasMatchingType = false;
                Node labelNode = (Node)xpath.evaluate("Label/text()", resultNode, XPathConstants.NODE);
                if (labelNode != null) {
                    label = labelNode.getNodeValue();
                }
                if ((uriNode = (Node)xpath.evaluate("URI/text()", resultNode, XPathConstants.NODE)) != null) {
                    uri = URI.create(uriNode.getNodeValue());
                }
                NodeList typeNodes = (NodeList)xpath.evaluate("Classes/Class/URI/text()", resultNode, XPathConstants.NODESET);
                for (int k = 0; k < typeNodes.getLength(); ++k) {
                    Node typeNode = typeNodes.item(k);
                    if (!acceptedTypes.contains(typeNode.getNodeValue())) continue;
                    hasMatchingType = true;
                    break;
                }
                if (!hasMatchingType || label == null || uri == null) continue;
                suggestions.add(new RemoteEntity(label, uri));
                if (suggestions.size() < maxSuggestions) continue;
                break;
            }
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e, (Throwable)e);
            List<RemoteEntity> list = Collections.emptyList();
            return list;
        }
        catch (FactoryConfigurationError e) {
            log.error((Object)e, (Throwable)e);
            List<RemoteEntity> list = Collections.emptyList();
            return list;
        }
        catch (XPathExpressionException e) {
            log.error((Object)e, (Throwable)e);
            List<RemoteEntity> list = Collections.emptyList();
            return list;
        }
        catch (SAXException e) {
            throw new IOException(String.format("Invalid suggestion response for '%s' with type '%s'", keywords, type), e);
        }
        finally {
            bodyStream.close();
        }
        return suggestions;
    }

    protected InputStream fetchResourceAsStream(URI sparqlURI, String format) throws MalformedURLException, IOException {
        HttpGet get = new HttpGet(sparqlURI);
        try {
            get.setHeader("Accept", format);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                InputStream content = response.getEntity().getContent();
                return content;
            }
            String errorMsg = String.format("Error resolving '%s' : ", sparqlURI);
            errorMsg = errorMsg + response.getStatusLine().toString();
            throw new IOException(errorMsg);
        }
        catch (ClientProtocolException e) {
            get.abort();
            throw e;
        }
        catch (IOException e) {
            get.abort();
            throw e;
        }
    }

    protected InputStream fetchSuggestions(String keywords, String type, int maxSuggestions) throws UnsupportedEncodingException, MalformedURLException, IOException {
        String escapedKeywords = URLEncoder.encode(keywords, "UTF-8");
        String escapedType = URLEncoder.encode(type, "UTF-8");
        String query = String.format(this.SUGGESTION_URL_PATTERN, escapedKeywords, escapedType, maxSuggestions);
        URL url = new URL(query);
        URLConnection connection = url.openConnection();
        connection.addRequestProperty("Accept", "application/xml");
        return connection.getInputStream();
    }
}

