/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.semanticentities.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.semanticentities.adapter.OccurrenceInfo;
import org.nuxeo.ecm.platform.semanticentities.adapter.OccurrenceRelation;

public class OccurrenceRelationImpl
implements OccurrenceRelation {
    protected DocumentModel doc;

    public OccurrenceRelationImpl(DocumentModel doc) {
        this.doc = doc;
    }

    public List<OccurrenceInfo> getOccurrences() throws ClientException {
        ArrayList<OccurrenceInfo> occurrences = new ArrayList<OccurrenceInfo>();
        List occMaps = (List)this.doc.getProperty("occurrence:quotes").getValue(List.class);
        for (Map occMap : occMaps) {
            OccurrenceInfo info = new OccurrenceInfo(((Serializable)occMap.get("text")).toString(), ((Long)occMap.get("startPos")).intValue(), ((Long)occMap.get("endPos")).intValue());
            occurrences.add(info);
        }
        return occurrences;
    }

    public void addOccurrences(List<OccurrenceInfo> occurrences) throws ClientException {
        LinkedHashSet<OccurrenceInfo> dedupedOccurrences = new LinkedHashSet<OccurrenceInfo>(this.getOccurrences());
        dedupedOccurrences.addAll(occurrences);
        ArrayList<Map> quotes = new ArrayList<Map>();
        for (OccurrenceInfo info : dedupedOccurrences) {
            quotes.add(info.asQuoteyMap());
        }
        this.doc.setPropertyValue("occurrence:quotes", (Serializable)quotes);
    }

    public void setOccurrences(List<OccurrenceInfo> occurrences) throws ClientException {
        ArrayList<Map> newQuotes = new ArrayList<Map>();
        for (OccurrenceInfo info : new LinkedHashSet<OccurrenceInfo>(occurrences)) {
            newQuotes.add(info.asQuoteyMap());
        }
        this.doc.setPropertyValue("occurrence:quotes", (Serializable)newQuotes);
    }

    public DocumentRef getSourceDocumentRef() throws ClientException {
        Serializable source = this.doc.getPropertyValue("relation:source");
        if (source != null) {
            return new IdRef(source.toString());
        }
        return null;
    }

    public DocumentRef getTargetEntityRef() throws ClientException {
        Serializable target = this.doc.getPropertyValue("relation:target");
        if (target != null) {
            return new IdRef(target.toString());
        }
        return null;
    }

    public DocumentModel getOccurrenceDocument() {
        return this.doc;
    }
}

