/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.semanticentities.service;

import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.semanticentities.DereferencingException;
import org.nuxeo.ecm.platform.semanticentities.EntitySuggestion;
import org.nuxeo.ecm.platform.semanticentities.LocalEntityService;
import org.nuxeo.ecm.platform.semanticentities.RemoteEntity;
import org.nuxeo.ecm.platform.semanticentities.RemoteEntityService;
import org.nuxeo.ecm.platform.semanticentities.adapter.OccurrenceInfo;
import org.nuxeo.ecm.platform.semanticentities.adapter.OccurrenceRelation;
import org.nuxeo.ecm.platform.semanticentities.service.CMISQLDocumentPageProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class LocalEntityServiceImpl
extends DefaultComponent
implements LocalEntityService {
    public static final Log log = LogFactory.getLog(LocalEntityServiceImpl.class);
    public static final String ENTITY_CONTAINER_PATH = "/default-domain/entities";
    public static final String ENTITY_CONTAINER_TITLE = "%i18nEntities";
    protected Map<String, DocumentRef> recentlyDereferenced = new MapMaker().concurrencyLevel(4).expiration(10L, TimeUnit.SECONDS).makeMap();

    public synchronized DocumentModel getEntityContainer(CoreSession session) throws ClientException {
        final PathRef ref = new PathRef(ENTITY_CONTAINER_PATH);
        if (!session.exists((DocumentRef)ref)) {
            int lastSlashIdx = ENTITY_CONTAINER_PATH.lastIndexOf(47);
            final String id = ENTITY_CONTAINER_PATH.substring(lastSlashIdx + 1);
            final String parentPath = ENTITY_CONTAINER_PATH.substring(0, lastSlashIdx + 1);
            UnrestrictedSessionRunner runner = new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    if (!this.session.exists((DocumentRef)ref)) {
                        DocumentModel entityContainer = this.session.createDocumentModel(parentPath, id, "EntityContainer");
                        entityContainer.setPropertyValue("dc:title", (Serializable)((Object)LocalEntityServiceImpl.ENTITY_CONTAINER_TITLE));
                        DocumentModel createdContainer = this.session.createDocument(entityContainer);
                        if (!LocalEntityServiceImpl.ENTITY_CONTAINER_PATH.equals(createdContainer.getPathAsString())) {
                            this.session.removeDocument(createdContainer.getRef());
                        } else {
                            String parentPath2 = entityContainer.getPathAsString();
                            DocumentModel occurrenceContainer = this.session.createDocumentModel(parentPath2, "occurrences", "OccurrenceContainer");
                            occurrenceContainer = this.session.createDocument(occurrenceContainer);
                            ACPImpl openAcp = new ACPImpl();
                            ACL acl = openAcp.getOrCreateACL();
                            acl.add((Object)new ACE("members", "Write", true));
                            acl.add((Object)new ACE("Everyone", "Browse", true));
                            openAcp.addACL(acl);
                            this.session.setACP(occurrenceContainer.getRef(), (ACP)openAcp, true);
                            this.session.save();
                        }
                    }
                }
            };
            runner.runUnrestricted();
        }
        if (!session.exists((DocumentRef)ref)) {
            return null;
        }
        return session.getDocument((DocumentRef)ref);
    }

    public DocumentModel getOccurrenceContainer(CoreSession session) throws ClientException {
        DocumentModel entityContainer = this.getEntityContainer(session);
        String parentPath = entityContainer.getPathAsString();
        String localId = "occurrences";
        PathRef occurrencesRef = new PathRef(parentPath + "/" + localId);
        return session.getDocument((DocumentRef)occurrencesRef);
    }

    public OccurrenceRelation addOccurrence(CoreSession session, DocumentRef docRef, DocumentRef entityRef, String quoteContext, int startPosInContext, int endPosInContext) throws ClientException {
        OccurrenceInfo info = new OccurrenceInfo(quoteContext, startPosInContext, endPosInContext);
        return this.addOccurrences(session, docRef, entityRef, Arrays.asList(info));
    }

    public OccurrenceRelation getOccurrenceRelation(CoreSession session, DocumentRef docRef, DocumentRef entityRef) throws ClientException {
        return this.getOccurrenceRelation(session, docRef, entityRef, false);
    }

    public OccurrenceRelation getOccurrenceRelation(CoreSession session, DocumentRef docRef, DocumentRef entityRef, boolean createIfMissing) throws ClientException {
        String q = String.format("SELECT * FROM Occurrence WHERE relation:source = '%s' AND relation:target = '%s' ORDER BY dc:created LIMIT 2", docRef, entityRef);
        DocumentModelList occurrences = session.query(q);
        if (occurrences.isEmpty()) {
            if (createIfMissing) {
                DocumentModel occ = session.createDocumentModel(this.getOccurrenceContainer(session).getPathAsString(), "occurrence-" + UUID.randomUUID().toString(), "Occurrence");
                occ.setPropertyValue("relation:source", (Serializable)((Object)docRef.toString()));
                occ.setPropertyValue("relation:target", (Serializable)((Object)entityRef.toString()));
                return (OccurrenceRelation)occ.getAdapter(OccurrenceRelation.class);
            }
            return null;
        }
        if (occurrences.size() > 1) {
            log.warn((Object)String.format("more than one occurrence found linking document '%s' to entity '%s'", docRef, entityRef));
        }
        return (OccurrenceRelation)((DocumentModel)occurrences.get(0)).getAdapter(OccurrenceRelation.class);
    }

    public void addOccurrences(CoreSession session, DocumentRef docRef, EntitySuggestion entitySuggestion, List<OccurrenceInfo> occurrences) throws ClientException, IOException {
        DocumentRef entityRef = null;
        if (entitySuggestion.isLocal()) {
            entityRef = entitySuggestion.localEntity.getRef();
        } else {
            for (String uri : entitySuggestion.remoteEntityUris) {
                entityRef = this.recentlyDereferenced.get(uri);
            }
            if (entityRef == null) {
                entityRef = this.asLocalEntity(session, entitySuggestion).getRef();
            }
        }
        this.addOccurrences(session, docRef, entityRef, occurrences);
    }

    public OccurrenceRelation addOccurrences(CoreSession session, DocumentRef docRef, DocumentRef entityRef, List<OccurrenceInfo> occurrences) throws ClientException {
        if (!session.hasPermission(docRef, "AddOccurrence")) {
            throw new SecurityException(String.format("%s has not the permission to add an entity occurrence on document with id '%s'", session.getPrincipal().getName(), docRef));
        }
        OccurrenceRelation relation = this.getOccurrenceRelation(session, docRef, entityRef, true);
        if (occurrences != null && !occurrences.isEmpty()) {
            relation.addOccurrences(occurrences);
        }
        UpdateOrCreateOccurrenceRelation op = new UpdateOrCreateOccurrenceRelation(session, relation);
        op.runUnrestricted();
        return (OccurrenceRelation)session.getDocument(op.occRef).getAdapter(OccurrenceRelation.class, true);
    }

    public PageProvider<DocumentModel> getRelatedDocuments(CoreSession session, DocumentRef entityRef, String documentType) throws ClientException {
        if (documentType == null) {
            documentType = "cmis:document";
        }
        if (!(entityRef instanceof IdRef)) {
            throw new NotImplementedException("Only IdRef instance are currently supported, got " + entityRef.getClass().getName());
        }
        String query = String.format("SELECT Doc.cmis:objectId FROM %s Doc JOIN Occurrence Occ ON Occ.relation:source = Doc.cmis:objectId WHERE Occ.relation:target = '%s' ORDER BY Doc.dc:modified DESC", documentType, entityRef);
        return new CMISQLDocumentPageProvider(session, query, "Doc.cmis:objectId", "relatedDocuments");
    }

    public PageProvider<DocumentModel> getRelatedEntities(CoreSession session, DocumentRef docRef, String entityType) throws ClientException {
        if (entityType == null) {
            entityType = "Entity";
        }
        if (!(docRef instanceof IdRef)) {
            throw new NotImplementedException("Only IdRef instance are currently supported, got " + docRef.getClass().getName());
        }
        String query = String.format("SELECT Ent.cmis:objectId FROM %s Ent JOIN Occurrence Occ ON Occ.relation:target = Ent.cmis:objectId WHERE Occ.relation:source = '%s' ORDER BY Ent.dc:title", entityType, docRef);
        return new CMISQLDocumentPageProvider(session, query, "Ent.cmis:objectId", "relatedEntities");
    }

    public static String cleanupKeywords(String keywords) {
        return keywords.replaceAll("\\W", " ").trim();
    }

    public List<DocumentModel> suggestLocalEntity(CoreSession session, String keywords, String type, int maxSuggestions) throws ClientException {
        Set<Object> entityTypeNames = new TreeSet<String>();
        if (type == null) {
            try {
                entityTypeNames = this.getEntityTypeNames();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            entityTypeNames.remove("Entity");
        } else {
            entityTypeNames.add(type);
        }
        String q = String.format("SELECT * FROM %s WHERE ecm:fulltext_title = '%s' AND ecm:primaryType IN ('%s') ORDER BY entity:popularity DESC, dc:title LIMIT %d", "Entity", LocalEntityServiceImpl.cleanupKeywords(keywords), StringUtils.join(entityTypeNames, (String)"', '"), maxSuggestions);
        return session.query(q);
    }

    public List<EntitySuggestion> suggestEntity(CoreSession session, String keywords, String type, int maxSuggestions) throws ClientException, DereferencingException {
        RemoteEntityService reService;
        try {
            reService = (RemoteEntityService)Framework.getService(RemoteEntityService.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List remoteEntities = Collections.emptyList();
        if (reService.canSuggestRemoteEntity()) {
            try {
                remoteEntities = reService.suggestRemoteEntity(keywords, type, maxSuggestions);
            }
            catch (IOException e) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
                try {
                    remoteEntities = reService.suggestRemoteEntity(keywords, type, maxSuggestions);
                }
                catch (IOException e2) {
                    log.warn((Object)String.format("failed to suggest remote entity for '%s' with type '%s': %s", keywords, type, e.getMessage()));
                }
            }
        }
        List<DocumentModel> localEntities = this.suggestLocalEntity(session, keywords, type, maxSuggestions);
        ArrayList<EntitySuggestion> suggestions = new ArrayList<EntitySuggestion>();
        double invScoreLocal = 10.0;
        HashSet<RemoteEntity> mergedRemoteEntities = new HashSet<RemoteEntity>();
        for (DocumentModel localEntity : localEntities) {
            EntitySuggestion suggestion = new EntitySuggestion(localEntity).withScore(1.0 / invScoreLocal);
            suggestions.add(suggestion);
            List sameas = (List)localEntity.getProperty("entity:sameas").getValue(List.class);
            if (sameas == null) {
                sameas = Collections.emptyList();
            }
            double invScoreRemote = 2.0;
            for (RemoteEntity remoteEntity : remoteEntities) {
                if (sameas.contains(remoteEntity.getUri().toString())) {
                    suggestion.remoteEntityUris.add(remoteEntity.uri.toString());
                    suggestion.score += 1.0 / invScoreRemote;
                    mergedRemoteEntities.add(remoteEntity);
                }
                invScoreRemote += 1.0;
            }
            invScoreLocal += 1.0;
        }
        remoteEntities.removeAll(mergedRemoteEntities);
        double invScoreRemote = 2.0;
        for (RemoteEntity remoteEntity : remoteEntities) {
            EntitySuggestion suggestion = new EntitySuggestion(remoteEntity.label, remoteEntity.uri.toString(), type).withScore(1.0 / invScoreRemote);
            Set types = Collections.emptySet();
            try {
                types = reService.getAdmissibleTypes(remoteEntity.uri);
            }
            catch (IOException e) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
                try {
                    types = reService.getAdmissibleTypes(remoteEntity.uri);
                }
                catch (IOException e1) {
                    log.warn((Object)String.format("failed to resolve admissible type for '%s': %s", remoteEntity.uri, e1.getMessage()));
                }
            }
            if (types.contains("Entity")) {
                types.remove("Entity");
            }
            if (types.size() <= 0) continue;
            suggestion.type = (String)types.iterator().next();
            suggestions.add(suggestion);
            invScoreRemote += 1.0;
        }
        Collections.sort(suggestions);
        Collections.reverse(suggestions);
        return suggestions;
    }

    public List<DocumentModel> suggestDocument(CoreSession session, String keywords, String type, int maxSuggestions) throws Exception {
        if (type == null) {
            type = "cmis:document";
        }
        String query = String.format("SELECT cmis:objectId, SCORE() relevance FROM %s WHERE CONTAINS('%s') AND cmis:objectTypeId NOT IN ('%s') ORDER BY relevance", type, LocalEntityServiceImpl.cleanupKeywords(keywords), StringUtils.join(this.getEntityTypeNames(), (String)"', '"));
        CMISQLDocumentPageProvider provider = new CMISQLDocumentPageProvider(session, query, "cmis:objectId", "suggestedDocuments");
        provider.setPageSize(maxSuggestions);
        return provider.getCurrentPage();
    }

    public Set<String> getEntityTypeNames() throws Exception {
        Set types = ((SchemaManager)Framework.getService(SchemaManager.class)).getDocumentTypeNamesExtending("Entity");
        return new TreeSet<String>(types);
    }

    public DocumentModel getLinkedLocalEntity(CoreSession session, URI remoteEntityURI) throws ClientException {
        String query = String.format("SELECT cmis:objectId FROM Entity WHERE '%s' = ANY entity:sameas ORDER BY dc:created", remoteEntityURI.toString());
        CMISQLDocumentPageProvider provider = new CMISQLDocumentPageProvider(session, query, "cmis:objectId", "linkedEntities");
        provider.setPageSize(1L);
        List currentPage = provider.getCurrentPage();
        long count = provider.getResultsCount();
        if (count == 0L) {
            return null;
        }
        if (count > 1L) {
            log.warn((Object)String.format("semantic inconsistency: found %d local entities linked to '%s'", count, remoteEntityURI));
        }
        return (DocumentModel)currentPage.get(0);
    }

    public DocumentModel asLocalEntity(CoreSession session, EntitySuggestion suggestion) throws ClientException, IOException {
        PathSegmentService psService;
        RemoteEntityService reService;
        if (suggestion.isLocal()) {
            return suggestion.localEntity;
        }
        if (suggestion.remoteEntityUris.isEmpty()) {
            throw new IllegalArgumentException("The provided suggestion has neither local entity nor emote entities links");
        }
        try {
            reService = (RemoteEntityService)Framework.getService(RemoteEntityService.class);
            psService = (PathSegmentService)Framework.getService(PathSegmentService.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DocumentModel entityContainer = this.getEntityContainer(session);
        DocumentModel localEntity = session.createDocumentModel(suggestion.type);
        localEntity.setPropertyValue("dc:title", (Serializable)((Object)suggestion.label));
        String pathSegment = psService.generatePathSegment(localEntity);
        localEntity.setPathInfo(entityContainer.getPathAsString(), pathSegment);
        for (String remoteEntity : suggestion.remoteEntityUris) {
            URI uri = URI.create(remoteEntity);
            reService.dereferenceInto(localEntity, uri, false);
        }
        localEntity = session.createDocument(localEntity);
        for (String remoteEntity : suggestion.remoteEntityUris) {
            this.recentlyDereferenced.put(remoteEntity, localEntity.getRef());
        }
        session.save();
        return localEntity;
    }

    protected static class UpdateOrCreateOccurrenceRelation
    extends UnrestrictedSessionRunner {
        protected final OccurrenceRelation relation;
        protected DocumentRef occRef;

        public UpdateOrCreateOccurrenceRelation(CoreSession session, OccurrenceRelation relation) {
            super(session);
            this.relation = relation;
        }

        public void run() throws ClientException {
            DocumentModel entity = null;
            try {
                entity = this.session.getDocument(this.relation.getTargetEntityRef());
            }
            catch (ClientException e) {
                // empty catch block
            }
            if (entity != null) {
                ArrayList<String> altnames = (ArrayList<String>)entity.getProperty("entity:altnames").getValue(List.class);
                for (OccurrenceInfo occInfo : this.relation.getOccurrences()) {
                    if (occInfo.mention.equals(entity.getPropertyValue("dc:title")) || altnames.contains(occInfo.mention)) continue;
                    altnames = new ArrayList<String>(altnames);
                    altnames.add(occInfo.mention);
                }
                entity.setPropertyValue("entity:altnames", (Serializable)altnames);
            }
            if (this.relation.getOccurrenceDocument().getId() == null) {
                this.occRef = this.session.createDocument(this.relation.getOccurrenceDocument()).getRef();
                if (entity != null) {
                    Long newPopularity = (Long)entity.getProperty("entity:popularity").getValue(Long.class) + 1L;
                    entity.setPropertyValue("entity:popularity", (Serializable)newPopularity);
                }
            } else {
                this.occRef = this.session.saveDocument(this.relation.getOccurrenceDocument()).getRef();
            }
            if (entity != null) {
                this.session.saveDocument(entity);
            }
            this.session.save();
        }
    }
}

