/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.semanticentities.service;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.semanticentities.DereferencingException;
import org.nuxeo.ecm.platform.semanticentities.RemoteEntity;
import org.nuxeo.ecm.platform.semanticentities.RemoteEntityService;
import org.nuxeo.ecm.platform.semanticentities.RemoteEntitySource;
import org.nuxeo.ecm.platform.semanticentities.service.ParameterizedRemoteEntitySource;
import org.nuxeo.ecm.platform.semanticentities.service.RemoteEntitySourceDescriptor;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class RemoteEntityServiceImpl
extends DefaultComponent
implements RemoteEntityService {
    private static final Log log = LogFactory.getLog(RemoteEntityServiceImpl.class);
    public static final String REMOTESOURCES_XP_NAME = "remoteSources";
    protected final List<RemoteEntitySourceDescriptor> registeredSourceDescriptors = new ArrayList<RemoteEntitySourceDescriptor>();
    protected HashMap<String, ParameterizedRemoteEntitySource> activeSources;

    protected HashMap<String, ParameterizedRemoteEntitySource> getActiveSources() {
        if (this.activeSources == null) {
            this.activeSources = new LinkedHashMap<String, ParameterizedRemoteEntitySource>();
            for (RemoteEntitySourceDescriptor descriptor : this.registeredSourceDescriptors) {
                String name = descriptor.getName();
                if (!descriptor.isEnabled() && this.activeSources.containsKey(name)) {
                    this.activeSources.remove(name);
                    continue;
                }
                this.activeSources.put(name, descriptor.getEntitySource());
            }
        }
        return this.activeSources;
    }

    protected RemoteEntitySource getSourceFor(URI remoteEntity) {
        for (ParameterizedRemoteEntitySource source : this.getActiveSources().values()) {
            if (!source.canDereference(remoteEntity)) continue;
            return source;
        }
        return null;
    }

    public void registerExtension(Extension extension) throws Exception {
        if (extension.getExtensionPoint().equals(REMOTESOURCES_XP_NAME)) {
            Object[] contribs;
            for (Object contrib : contribs = extension.getContributions()) {
                if (!(contrib instanceof RemoteEntitySourceDescriptor)) continue;
                this.registerRemoteEntitySourceDescriptor((RemoteEntitySourceDescriptor)contrib, extension);
            }
        }
    }

    protected void registerRemoteEntitySourceDescriptor(RemoteEntitySourceDescriptor descriptor, Extension extension) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        descriptor.initializeInContext(extension.getContext());
        this.registeredSourceDescriptors.add(descriptor);
        this.activeSources = null;
    }

    public void unregisterExtension(Extension extension) throws Exception {
        if (extension.getExtensionPoint().equals(REMOTESOURCES_XP_NAME)) {
            Object[] contribs;
            for (Object contrib : contribs = extension.getContributions()) {
                if (!(contrib instanceof RemoteEntitySourceDescriptor)) continue;
                this.unregisterRemoteEntitySourceDescriptor((RemoteEntitySourceDescriptor)contrib, extension);
            }
        }
    }

    protected void unregisterRemoteEntitySourceDescriptor(RemoteEntitySourceDescriptor descriptor, Extension extension) {
        int index = this.registeredSourceDescriptors.lastIndexOf(descriptor);
        if (index != -1) {
            this.registeredSourceDescriptors.remove(index);
            this.activeSources = null;
        } else {
            log.warn((Object)String.format("no registered remote source under name '%s'", descriptor.getName()));
        }
    }

    public boolean canSuggestRemoteEntity() {
        for (ParameterizedRemoteEntitySource source : this.getActiveSources().values()) {
            if (!source.canSuggestRemoteEntity()) continue;
            return true;
        }
        return false;
    }

    public boolean canDereference(URI remoteEntity) {
        return this.getSourceFor(remoteEntity) != null;
    }

    public void dereferenceInto(DocumentModel localEntity, URI remoteEntity, boolean override) throws DereferencingException {
        this.getSourceFor(remoteEntity).dereferenceInto(localEntity, remoteEntity, override);
    }

    public List<RemoteEntity> suggestRemoteEntity(String keywords, String type, int maxSuggestions) throws IOException {
        ArrayList<RemoteEntity> suggestions = new ArrayList<RemoteEntity>();
        for (ParameterizedRemoteEntitySource source : this.getActiveSources().values()) {
            if (!source.canSuggestRemoteEntity()) continue;
            suggestions.addAll(source.suggestRemoteEntity(keywords, type, maxSuggestions));
        }
        return suggestions;
    }

    public Set<String> getAdmissibleTypes(URI remoteEntity) throws DereferencingException {
        TreeSet<String> types = new TreeSet<String>();
        for (ParameterizedRemoteEntitySource source : this.getActiveSources().values()) {
            if (!source.canDereference(remoteEntity)) continue;
            types.addAll(source.getAdmissibleTypes(remoteEntity));
        }
        return types;
    }

    public void removeSameAsLink(DocumentModel doc, URI uriToRemove) throws ClientException {
        if (doc.getPropertyValue("entity:sameas") == null) {
            return;
        }
        String uriAsString = uriToRemove.toString();
        ArrayList<String> filteredURIs = new ArrayList<String>();
        ArrayList<String> filteredLabels = new ArrayList<String>();
        String[] oldURIs = (String[])doc.getProperty("entity:sameas").getValue(String[].class);
        String[] oldLabels = (String[])doc.getProperty("entity:sameasDisplayLabel").getValue(String[].class);
        boolean changed = false;
        for (int i = 0; i < oldURIs.length; ++i) {
            if (uriAsString.equals(oldURIs[i])) {
                changed = true;
                continue;
            }
            filteredURIs.add(oldURIs[i]);
            filteredLabels.add(oldLabels[i]);
        }
        if (changed) {
            doc.setPropertyValue("entity:sameas", filteredURIs);
            doc.setPropertyValue("entity:sameasDisplayLabel", filteredLabels);
        }
    }
}

