/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.semanticentities;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;

public class EntitySuggestion
implements Comparable<EntitySuggestion>,
Serializable {
    private static final long serialVersionUID = 1L;
    public String label;
    public DocumentModel localEntity;
    public String type;
    public final Set<String> remoteEntityUris = new LinkedHashSet<String>();
    public double score = 0.0;

    public EntitySuggestion(DocumentModel localEntity) throws ClientException {
        this.localEntity = localEntity;
        this.label = localEntity.getTitle();
        this.type = localEntity.getType();
    }

    public EntitySuggestion(String label, String remoteEntityUri, String type) {
        this.label = label;
        this.remoteEntityUris.add(remoteEntityUri);
        this.type = type;
    }

    public EntitySuggestion withScore(double score) {
        this.score = score;
        return this;
    }

    public boolean isLocal() {
        return this.localEntity != null;
    }

    @Override
    public int compareTo(EntitySuggestion o) {
        return (int)Math.signum(this.score - o.score);
    }

    public String getLabel() {
        return this.label;
    }

    public String getType() {
        return this.type;
    }

    public String getLocalId() {
        if (this.isLocal()) {
            return this.localEntity.getId();
        }
        return null;
    }

    public String getRemoteURI() {
        if (!this.remoteEntityUris.isEmpty()) {
            return this.remoteEntityUris.iterator().next();
        }
        return null;
    }
}

