/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.semanticentities;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;

public class RemoteEntity {
    public static final String SAMEAS_URI_PROPERTY = "entity:sameas";
    public static final String SAMEAS_LABEL_PROPERTY = "entity:sameasDisplayLabel";
    public static final Log log = LogFactory.getLog(RemoteEntity.class);
    public final String label;
    public final URI uri;

    public RemoteEntity(String label, URI uri) {
        if (label == null || uri == null) {
            throw new IllegalArgumentException("label and uri must not be null");
        }
        this.label = label;
        this.uri = uri;
    }

    public RemoteEntity(String label, String uri) {
        if (label == null || uri == null) {
            throw new IllegalArgumentException("label and uri must not be null");
        }
        this.label = label;
        this.uri = URI.create(uri);
    }

    public static List<RemoteEntity> fromDocument(DocumentModel doc) throws ClientException {
        Object[] entityURIs = (String[])doc.getProperty(SAMEAS_URI_PROPERTY).getValue(String[].class);
        Object[] entityLabels = (String[])doc.getProperty(SAMEAS_LABEL_PROPERTY).getValue(String[].class);
        ArrayList<RemoteEntity> entities = new ArrayList<RemoteEntity>();
        if (entityURIs.length != entityLabels.length) {
            log.warn((Object)String.format("inconsistent linked remote entities for local entity '%s': (%s) and (%s)", doc.getTitle(), StringUtils.join((Object[])entityURIs), StringUtils.join((Object[])entityLabels)));
            return entities;
        }
        for (int i = 0; i < entityURIs.length; ++i) {
            entities.add(new RemoteEntity(entityLabels[i], (String)entityURIs[i]));
        }
        return entities;
    }

    public String getLabel() {
        return this.label;
    }

    public URI getUri() {
        return this.uri;
    }
}

