/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.shibboleth.auth;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.shibboleth.service.ShibbolethAuthenticationService;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPluginLogoutExtension;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class ShibbolethAuthenticationPlugin
implements NuxeoAuthenticationPlugin,
NuxeoAuthenticationPluginLogoutExtension {
    private static final Log log = LogFactory.getLog(ShibbolethAuthenticationPlugin.class);
    protected ShibbolethAuthenticationService service;

    protected ShibbolethAuthenticationService getService() {
        if (this.service == null) {
            try {
                this.service = (ShibbolethAuthenticationService)Framework.getService(ShibbolethAuthenticationService.class);
            }
            catch (Exception e) {
                log.error((Object)"Failed to get Shibboleth authentication service", (Throwable)e);
            }
        }
        return this.service;
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        if (this.getService() == null) {
            return false;
        }
        String loginURL = this.getService().getLoginURL(httpRequest);
        if (loginURL == null) {
            log.error((Object)"Unable to handle Shibboleth login, no loginURL registered");
            return false;
        }
        try {
            httpResponse.sendRedirect(loginURL);
        }
        catch (IOException e) {
            String errorMessage = String.format("Unable to handle Shibboleth login on %s", loginURL);
            log.error((Object)errorMessage, (Throwable)e);
            return false;
        }
        return true;
    }

    public Boolean handleLogout(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (this.getService() == null) {
            return false;
        }
        String logoutURL = this.getService().getLogoutURL(httpRequest);
        if (logoutURL == null) {
            return false;
        }
        try {
            httpResponse.sendRedirect(logoutURL);
        }
        catch (IOException e) {
            log.error((Object)"Unable to handle Shibboleth logout", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (this.getService() == null) {
            return null;
        }
        String userId = this.getService().getUserID(httpRequest);
        if (userId == null || "".equals(userId)) {
            return null;
        }
        Session userDir = null;
        try {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            userDir = ((DirectoryService)Framework.getService(DirectoryService.class)).open(userManager.getUserDirectoryName());
            Map<String, Object> fieldMap = this.getService().getUserMetadata(userManager.getUserIdField(), httpRequest);
            DocumentModel entry = userDir.getEntry(userId);
            if (entry == null) {
                userDir.createEntry(fieldMap);
            } else {
                entry.getDataModel(userManager.getUserSchemaName()).setMap(fieldMap);
                userDir.updateEntry(entry);
            }
            userDir.commit();
        }
        catch (Exception e) {
            log.error((Object)"Failed to get or create user entry", (Throwable)e);
        }
        finally {
            if (userDir != null) {
                try {
                    userDir.close();
                }
                catch (DirectoryException e) {
                    log.error((Object)"Error while closing directory session", (Throwable)e);
                }
            }
        }
        return new UserIdentificationInfo(userId, userId);
    }

    public void initPlugin(Map<String, String> parameters) {
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return true;
    }
}

