/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.shibboleth;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.InvalidPropertyValueException;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.shibboleth.computedgroups.ELGroupComputerHelper;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.exceptions.GroupAlreadyExistsException;
import org.nuxeo.runtime.api.Framework;

public class ShibbolethGroupHelper {
    private static final Log log = LogFactory.getLog(ShibbolethGroupHelper.class);
    protected static DirectoryService directory;
    protected static UserManager userManager;

    private ShibbolethGroupHelper() {
    }

    protected static DirectoryService getDirectoryService() {
        if (directory == null) {
            try {
                directory = (DirectoryService)Framework.getService(DirectoryService.class);
            }
            catch (Exception e) {
                log.error((Object)"Failed to open directory service", (Throwable)e);
            }
        }
        return directory;
    }

    protected static UserManager getUserManager() {
        if (userManager == null) {
            try {
                userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                log.error((Object)"Cannot access the userManager Service");
            }
        }
        return userManager;
    }

    public static DocumentModel getBareGroupModel(CoreSession core) throws ClientException {
        return core.createDocumentModel("shibbGroup");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentModel createGroup(DocumentModel group) throws ClientException {
        try (Session session = null;){
            session = ShibbolethGroupHelper.getDirectoryService().open("shibbGroup");
            if (session.hasEntry(group.getPropertyValue("shibbolethGroup:groupName").toString())) {
                throw new GroupAlreadyExistsException();
            }
            ShibbolethGroupHelper.checkExpressionLanguageValidity(group);
            group = session.createEntry(group);
            session.commit();
            DocumentModel documentModel = group;
            return documentModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentModel getGroup(String groupName) throws DirectoryException {
        try (Session session = null;){
            session = ShibbolethGroupHelper.getDirectoryService().open("shibbGroup");
            DocumentModel documentModel = session.getEntry(groupName);
            return documentModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateGroup(DocumentModel group) throws ClientException {
        try (Session session = null;){
            session = ShibbolethGroupHelper.getDirectoryService().open("shibbGroup");
            ShibbolethGroupHelper.checkExpressionLanguageValidity(group);
            session.updateEntry(group);
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteGroup(DocumentModel group) throws ClientException {
        try (Session session = null;){
            session = ShibbolethGroupHelper.getDirectoryService().open("shibbGroup");
            session.deleteEntry(group);
            session.commit();
        }
    }

    public static List<String> getParentsGroups(String shibbGroupName) throws ClientException {
        Directory dir = ShibbolethGroupHelper.getDirectoryService().getDirectory(ShibbolethGroupHelper.getUserManager().getGroupDirectoryName());
        Reference subGroups = dir.getReference(ShibbolethGroupHelper.getUserManager().getGroupSubGroupsField());
        List ret = subGroups.getSourceIdsForTarget(shibbGroupName);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentModelList getGroups() throws ClientException {
        try (Session session = null;){
            session = ShibbolethGroupHelper.getDirectoryService().open("shibbGroup");
            DocumentModelList documentModelList = session.getEntries();
            return documentModelList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentModelList searchGroup(String fullText) throws ClientException {
        try (Session session = null;){
            session = ShibbolethGroupHelper.getDirectoryService().open("shibbGroup");
            HashMap<String, String> filters = new HashMap<String, String>();
            if (fullText != null && !"".equals(fullText)) {
                filters.put("groupName", fullText);
            }
            HashMap<String, String> orderBy = new HashMap<String, String>();
            orderBy.put("groupName", "asc");
            DocumentModelList documentModelList = session.query(filters, new HashSet(filters.keySet()), orderBy);
            return documentModelList;
        }
    }

    protected static void checkExpressionLanguageValidity(DocumentModel group) throws ClientException {
        String expressionLanguage = (String)((Object)group.getPropertyValue("shibbolethGroup:expressionLanguage"));
        if (!ELGroupComputerHelper.isValidEL(expressionLanguage)) {
            throw new InvalidPropertyValueException(expressionLanguage + " : is not a valid expression language");
        }
    }
}

