/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.shibboleth.service;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.platform.shibboleth.service.ShibbolethAuthenticationConfig;
import org.nuxeo.ecm.platform.shibboleth.service.ShibbolethAuthenticationService;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ShibbolethAuthenticationServiceImpl
extends DefaultComponent
implements ShibbolethAuthenticationService {
    public static final String CONFIG_EP = "config";
    protected ShibbolethAuthenticationConfig config;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIG_EP.equals(extensionPoint)) {
            this.config = (ShibbolethAuthenticationConfig)contribution;
        }
    }

    public ShibbolethAuthenticationConfig getConfig() {
        return this.config;
    }

    @Override
    public String getLoginURL(String redirectURL) {
        if (this.config == null || this.config.getLoginURL() == null) {
            return null;
        }
        HashMap<String, String> urlParameters = new HashMap<String, String>(1);
        urlParameters.put(this.config.getLoginRedirectURLParameter(), redirectURL);
        return URIUtils.addParametersToURIQuery((String)this.config.getLoginURL(), urlParameters);
    }

    @Override
    public String getLogoutURL(String redirectURL) {
        if (this.config == null || this.config.getLogoutURL() == null) {
            return null;
        }
        HashMap<String, String> urlParameters = new HashMap<String, String>(1);
        urlParameters.put(this.config.getLogoutRedirectURLParameter(), redirectURL);
        return URIUtils.addParametersToURIQuery((String)this.config.getLogoutURL(), urlParameters);
    }

    protected static String getRedirectUrl(HttpServletRequest request) {
        String redirectURL = VirtualHostHelper.getBaseURL((ServletRequest)request);
        if (request.getAttribute("requestedUrl") != null) {
            redirectURL = redirectURL + request.getAttribute("requestedUrl");
        } else if (request.getParameter("requestedUrl") != null) {
            redirectURL = redirectURL + request.getParameter("requestedUrl");
        } else {
            redirectURL = request.getRequestURL().toString();
            String queryString = request.getQueryString();
            if (queryString != null) {
                redirectURL = redirectURL + '?' + queryString;
            }
        }
        return redirectURL;
    }

    @Override
    public String getLoginURL(HttpServletRequest request) {
        return this.getLoginURL(ShibbolethAuthenticationServiceImpl.getRedirectUrl(request));
    }

    @Override
    public String getLogoutURL(HttpServletRequest request) {
        return this.getLogoutURL(ShibbolethAuthenticationServiceImpl.getRedirectUrl(request));
    }

    @Override
    public String getUserID(HttpServletRequest httpRequest) {
        String idpUrl = httpRequest.getHeader(this.config.getIdpHeader());
        String uidHeader = this.config.getUidHeaders().get(idpUrl);
        if (uidHeader == null || this.readHeader(httpRequest, uidHeader) == null || this.readHeader(httpRequest, uidHeader).isEmpty()) {
            uidHeader = this.config.getDefaultUidHeader();
        }
        return this.readHeader(httpRequest, uidHeader);
    }

    @Override
    public Map<String, Object> getUserMetadata(String userIdField, HttpServletRequest httpRequest) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>(this.config.fieldMapping.size());
        for (String key : this.config.getFieldMapping().keySet()) {
            fieldMap.put(this.config.getFieldMapping().get(key), this.readHeader(httpRequest, key));
        }
        fieldMap.put(userIdField, this.getUserID(httpRequest));
        return fieldMap;
    }

    protected String readHeader(HttpServletRequest request, String key) {
        String value = request.getHeader(key);
        if (StringUtils.isNotEmpty((String)value) && StringUtils.isNotEmpty((String)this.config.getHeaderEncoding())) {
            try {
                value = new String(value.getBytes("ISO-8859-1"), this.config.getHeaderEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return value;
    }
}

