/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.shibboleth.auth.exceptionhandling;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.web.Session;
import org.nuxeo.ecm.platform.shibboleth.service.ShibbolethAuthenticationService;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.NuxeoSecurityExceptionHandler;
import org.nuxeo.runtime.api.Framework;

public class ShibbolethSecurityExceptionHandler
extends NuxeoSecurityExceptionHandler {
    private static final Log log = LogFactory.getLog(ShibbolethSecurityExceptionHandler.class);

    protected boolean handleAnonymousException(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.getService() == null) {
            return false;
        }
        String loginURL = this.getService().getLoginURL(request);
        if (loginURL == null) {
            log.error((Object)"Unable to handle Shibboleth login, no loginURL registered");
            return false;
        }
        try {
            if (!response.isCommitted()) {
                request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)true);
                Session.instance().invalidate();
                response.sendRedirect(loginURL);
                FacesContext fContext = FacesContext.getCurrentInstance();
                if (fContext != null) {
                    fContext.responseComplete();
                } else {
                    log.error((Object)"Cannot set response complete: faces context is null");
                }
            } else {
                log.error((Object)"Cannot redirect to login page: response is already commited");
            }
        }
        catch (IOException e) {
            String errorMessage = String.format("Unable to handle Shibboleth login on %s", loginURL);
            log.error((Object)errorMessage, (Throwable)e);
        }
        return true;
    }

    protected ShibbolethAuthenticationService getService() {
        return (ShibbolethAuthenticationService)Framework.getService(ShibbolethAuthenticationService.class);
    }
}

